/*
 * Copyright (C) 2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.web.service;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;
import org.videolan.vlma.Data;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.StreamingStrategy;

/**
 * Abstract playlist controller.
 *
 * @author Adrien Grand <jpountz at videolan.org>
 */
public class AbstractPlaylistController implements Controller {

    private Data data;

    /**
     * Sets the data.
     *
     * @param data the data to set
     */
    public void setData(Data data) {
        this.data = data;
    }

    protected static StreamingStrategy.Announcement announcement;

    public ModelAndView handleRequest(HttpServletRequest arg0,
            HttpServletResponse arg1) throws Exception {
        ModelAndView mav = new ModelAndView();
        Map<Media, String> medias = new HashMap<Media, String>();
        for (Media media : data.getMedias()) {
            if (media.getProgram() != null
                    && media.getProgram().getPlayer() != null
                    && media.getProgram().getStreamingStrategy().isEnabled(announcement)) {
                medias.put(media, data.getUrlOfProgram(media.getProgram()));
            }
        }
        mav.addObject("medias", medias);
        return mav;
    }

}
