/*
 * Copyright (C) 2006-2008 the VideoLAN team
 *
 * This file is part of VLMa.
 *
 * VLMa is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * VLMa is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VLMa. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package org.videolan.vlma.watcher;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

import org.apache.commons.configuration.Configuration;
import org.videolan.vlma.model.Program;

/**
 * This class monitors HTTP streams. It should never be used directly. Use
 * {@link StreamWatcherDispatcher} instead.
 *
 * @author Adrien Grand <jpountz at videolan.org>
 */
public class HttpStreamWatcher implements StreamWatcher, Serializable {

    private static final long serialVersionUID = -7277103439483762155L;

    private Configuration configuration;

    public boolean isPlayed(Program program) {
        if (program.getPlayer() == null) {
            return false;
        }
        Integer port = configuration.getInt("vlma.streaming.http.port");
        URL url;
        try {
            url = new URL("http://" + program.getPlayer().getHostAddress() + ":" + port + "/" + program.hashCode());
        } catch (MalformedURLException e) {
            return false;
        }
        URLConnection conn;
        try {
            conn = url.openConnection();
            if (conn == null) return false;
            if (conn.getContentType() != null && conn.getContentType().contains("application/octet-stream")) {
                return true;
            } else {
                return false;
            }
        } catch (IOException e) {
            return false;
        }
    }

    /**
     * @param configuration the configuration to set
     */
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

}
