/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.watcher;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.configuration.Configuration;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.watcher.StreamWatcher;

public class HttpStreamWatcher
implements StreamWatcher,
Serializable {
    private static final long serialVersionUID = -7277103439483762155L;
    private Configuration configuration;

    public boolean isPlayed(Program program) {
        URL url;
        if (program.getPlayer() == null) {
            return false;
        }
        Integer port = this.configuration.getInt("vlma.streaming.http.port");
        try {
            url = new URL("http://" + program.getPlayer().getHostAddress() + ":" + port + "/" + program.hashCode());
        }
        catch (MalformedURLException e) {
            return false;
        }
        try {
            URLConnection conn = url.openConnection();
            if (conn == null) {
                return false;
            }
            return conn.getContentType() != null && conn.getContentType().contains("application/octet-stream");
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

