/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.videolan.vlma.VLMaService;
import org.videolan.vlma.model.Adapter;
import org.videolan.vlma.model.FilesAdapter;
import org.videolan.vlma.model.FilesChannel;
import org.videolan.vlma.model.Media;
import org.videolan.vlma.model.MediaGroup;
import org.videolan.vlma.model.Order;
import org.videolan.vlma.model.Program;
import org.videolan.vlma.model.Server;
import org.videolan.vlma.order.OrderSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderGiver {
    private static final Logger logger = Logger.getLogger(OrderGiver.class);
    public static final int SLEEP_AFTER_ORDERS = 5000;
    private VLMaService vlmaService;
    private OrderSender orderSender;
    private Thread computingThread;
    private Runnable orderComputer = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set<Order> orders;
            logger.info((Object)"Starting computing channels assignment.");
            long start = System.currentTimeMillis();
            Map<String, List<Adapter>> adapters = OrderGiver.this.partitionAdapters(OrderGiver.this.vlmaService.getServers());
            Map<String, List<MediaGroup>> groups = OrderGiver.this.partitionMedias(OrderGiver.this.vlmaService.getMedias(), adapters);
            Set<Order> newOrders = OrderGiver.this.computeOrders(groups, adapters);
            logger.info((Object)("Orders computation done in " + (System.currentTimeMillis() - start) + "ms"));
            logger.info((Object)"Now sending orders");
            start = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(newOrders.size() + " orders have been computed"));
            }
            HashSet<Order> oldOrders = new HashSet<Order>();
            Set<Order> set = orders = OrderGiver.this.vlmaService.getOrders();
            synchronized (set) {
                Set<Order> ordersToCancel;
                oldOrders.addAll(orders);
                oldOrders.removeAll(newOrders);
                for (Order order : oldOrders) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(oldOrders.size() + " orders to remove"));
                    }
                    try {
                        OrderGiver.this.orderSender.stop(order);
                    }
                    catch (IOException e) {
                        logger.error((Object)("Error while trying to stop an order of " + order.getAdapter().getServer().getName()), (Throwable)e);
                        OrderGiver.this.vlmaService.cancelOrder(order);
                    }
                    for (Media media : order.getMedias()) {
                        Program p = media.getProgram();
                        if (p == null) continue;
                        p.setPlayer(null);
                        p.setBroadcastState(false);
                    }
                }
                newOrders.removeAll(orders);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(newOrders.size() + " new orders to send"));
                }
                HashMap<Server, SendOrder> sendThreads = new HashMap<Server, SendOrder>();
                for (Order order : newOrders) {
                    for (Media media : order.getMedias()) {
                        media.getProgram().setPlayer(order.getAdapter().getServer().getIp());
                    }
                    SendOrder sendThread = (SendOrder)sendThreads.get(order.getAdapter().getServer());
                    if (sendThread == null) {
                        sendThread = new SendOrder();
                        sendThreads.put(order.getAdapter().getServer(), sendThread);
                    }
                    sendThread.addOrder(order);
                }
                for (SendOrder thread : sendThreads.values()) {
                    thread.start();
                }
                for (SendOrder thread : sendThreads.values()) {
                    try {
                        thread.join();
                    }
                    catch (InterruptedException e) {}
                }
                orders.removeAll(oldOrders);
                orders.addAll(newOrders);
                Set<Order> set2 = ordersToCancel = OrderGiver.this.vlmaService.getOrdersToCancel();
                synchronized (set2) {
                    ordersToCancel.removeAll(orders);
                }
            }
            logger.info((Object)("Orders sent in " + (System.currentTimeMillis() - start) + "ms"));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    };

    public void setVlmaService(VLMaService vlmaService) {
        this.vlmaService = vlmaService;
    }

    public void setOrderSender(OrderSender orderSender) {
        this.orderSender = orderSender;
    }

    public boolean isComputing() {
        return this.computingThread != null && this.computingThread.isAlive();
    }

    public Map<String, List<Adapter>> partitionAdapters(List<Server> servers) {
        int nbAdapters = 0;
        HashMap<String, List<Adapter>> adapters = new HashMap<String, List<Adapter>>();
        for (Server server : servers) {
            if (!server.isUp()) continue;
            for (Adapter adapter : server.getAdapters()) {
                if (!adapter.isUp()) continue;
                ++nbAdapters;
                ArrayList<Adapter> sameTypeAdapters = (ArrayList<Adapter>)adapters.get(adapter.getType());
                if (sameTypeAdapters == null) {
                    sameTypeAdapters = new ArrayList<Adapter>();
                    adapters.put(adapter.getType(), sameTypeAdapters);
                }
                sameTypeAdapters.add(adapter);
            }
        }
        logger.debug((Object)(nbAdapters + " available adapters"));
        return adapters;
    }

    public Map<String, List<MediaGroup>> partitionMedias(List<Media> medias, Map<String, List<Adapter>> adapters) {
        int nbMedias = 0;
        int nbGroups = 0;
        HashMap<String, List<MediaGroup>> groups = new HashMap<String, List<MediaGroup>>();
        for (Media media : medias) {
            if (media.getProgram() == null || !media.getProgram().isTimeToPlay()) continue;
            ++nbMedias;
            for (Map.Entry<String, List<Adapter>> sameTypeAdapters : adapters.entrySet()) {
                if (!sameTypeAdapters.getValue().get(0).canRead(media) && (!(media instanceof FilesChannel) || !(sameTypeAdapters.getValue().get(0) instanceof FilesAdapter))) continue;
                ArrayList<MediaGroup> sameTypeGroups = (ArrayList<MediaGroup>)groups.get(sameTypeAdapters.getKey());
                boolean mediaAdded = false;
                if (sameTypeGroups == null) {
                    sameTypeGroups = new ArrayList<MediaGroup>();
                    groups.put(sameTypeAdapters.getKey(), sameTypeGroups);
                } else {
                    for (MediaGroup group : sameTypeGroups) {
                        if (!media.belongsToGroup(group)) continue;
                        group.add((Object)media);
                        mediaAdded = true;
                        break;
                    }
                }
                if (mediaAdded) continue;
                MediaGroup group = new MediaGroup();
                ++nbGroups;
                group.add((Object)media);
                sameTypeGroups.add(group);
            }
        }
        return groups;
    }

    public Set<Order> computeOrders(Map<String, List<MediaGroup>> groups, Map<String, List<Adapter>> adapters) {
        HashMap<Server, Integer> nbMediasByServer = new HashMap<Server, Integer>();
        for (List<Adapter> adapterList : adapters.values()) {
            for (Adapter adapter : adapterList) {
                nbMediasByServer.put(adapter.getServer(), 0);
            }
        }
        HashSet<Order> orders = new HashSet<Order>();
        for (Map.Entry<String, List<MediaGroup>> entry : groups.entrySet()) {
            if (!this.isSatOrDTT(entry.getKey())) continue;
            this.computeOrdersByAvailableAdapters(entry.getValue(), adapters.get(entry.getKey()), orders, nbMediasByServer);
        }
        for (Map.Entry<String, List<MediaGroup>> entry : groups.entrySet()) {
            if (this.isSatOrDTT(entry.getKey())) continue;
            this.computeOrdersByLowerLoad(entry.getValue(), orders, nbMediasByServer);
        }
        return orders;
    }

    private boolean isSatOrDTT(String key) {
        return key.startsWith("DVB-T adapter") || key.startsWith("DVB-S adapter");
    }

    private void computeOrdersByAvailableAdapters(List<MediaGroup> groups, List<Adapter> adapters, Set<Order> orders, Map<Server, Integer> nbMediasByServer) {
        Collections.sort(groups);
        Iterator<MediaGroup> groupIt = groups.iterator();
        Iterator<Adapter> adapterIt = adapters.iterator();
        while (groupIt.hasNext() && adapterIt.hasNext()) {
            Adapter a = adapterIt.next();
            MediaGroup g = groupIt.next();
            Order order = new Order(a, g);
            orders.add(order);
            int groupSize = g.size();
            nbMediasByServer.put(a.getServer(), nbMediasByServer.get(a.getServer()) + groupSize);
        }
        while (groupIt.hasNext()) {
            logger.warn((Object)"The following medias cannot be streamed because there is not enough adapters:");
            for (Media media : groupIt.next()) {
                logger.warn((Object)(" - " + media.getName()));
            }
        }
    }

    private void computeOrdersByLowerLoad(List<MediaGroup> groups, Set<Order> orders, Map<Server, Integer> nbMediasByServer) {
        for (MediaGroup group : groups) {
            Adapter bestAdapter = null;
            int nbMediasBestAdapter = Integer.MAX_VALUE;
            for (Map.Entry<Server, Integer> entry : nbMediasByServer.entrySet()) {
                Server server = entry.getKey();
                int nbMedias = entry.getValue();
                for (Adapter adapter : server.getAdapters()) {
                    if (!adapter.canRead(group) || nbMedias >= nbMediasBestAdapter) continue;
                    bestAdapter = adapter;
                    nbMediasBestAdapter = nbMediasByServer.get(adapter.getServer());
                }
            }
            if (bestAdapter != null) {
                Order order = new Order(bestAdapter, group);
                orders.add(order);
                nbMediasByServer.put(bestAdapter.getServer(), nbMediasBestAdapter + group.size());
                continue;
            }
            logger.warn((Object)"Cannot find any adapter for media group containing the following medias:");
            for (Media media : group) {
                logger.warn((Object)(" - " + media.getName()));
            }
        }
    }

    public synchronized void giveOrders() {
        if (!this.isComputing()) {
            this.computingThread = new Thread(this.orderComputer);
            this.computingThread.setName("OrderComputingThread");
            this.computingThread.start();
        }
    }

    private class SendOrder
    extends Thread {
        private List<Order> orders = new ArrayList<Order>();

        public void addOrder(Order order) {
            this.orders.add(order);
        }

        public void run() {
            for (Order order : this.orders) {
                try {
                    OrderGiver.this.orderSender.start(order);
                }
                catch (IOException e) {
                    logger.error((Object)("Error while trying to send an order to " + order.getAdapter().getServer()), (Throwable)e);
                }
            }
        }
    }
}

