/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.util.HashMap;
import org.jrobin.core.RrdException;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.Cdef;
import org.jrobin.graph.Source;

class Sdef
extends Cdef {
    private int defIndex = -1;
    private String defName = "";
    private String consolFunc = "AVERAGE";
    private int aggregate = 2;
    private boolean calculated = false;
    private double[] value = null;

    Sdef(String string, String string2, String string3) throws RrdException {
        super(string);
        this.defName = string2;
        this.consolFunc = string3;
        if (string3.equalsIgnoreCase("AVERAGE") || string3.equalsIgnoreCase("AVG")) {
            this.aggregate = 2;
        } else if (string3.equalsIgnoreCase("MAX") || string3.equalsIgnoreCase("MAXIMUM")) {
            this.aggregate = 1;
        } else if (string3.equalsIgnoreCase("MIN") || string3.equalsIgnoreCase("MINIMUM")) {
            this.aggregate = 0;
        } else if (string3.equalsIgnoreCase("LAST")) {
            this.aggregate = 4;
        } else if (string3.equalsIgnoreCase("FIRST")) {
            this.aggregate = 3;
        } else if (string3.equalsIgnoreCase("TOTAL")) {
            this.aggregate = 5;
        } else {
            throw new RrdException("Invalid consolidation function specified.");
        }
    }

    void prepare(HashMap hashMap, int n, int n2) throws RrdException {
        if (!hashMap.containsKey(this.defName)) {
            throw new RrdException("Datasource not found: " + this.defName);
        }
        this.defIndex = (Integer)hashMap.get(this.defName);
        this.values = new double[n];
        this.aggregatePoints = n2;
        this.calculated = false;
    }

    int calculateLevel(int[] nArray) {
        return nArray[this.defIndex] + 1;
    }

    double get(int n) {
        return this.values[0];
    }

    void set(Source[] sourceArray) {
        if (this.calculated) {
            return;
        }
        double d = sourceArray[this.defIndex].getAggregate(this.aggregate);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = d;
        }
        this.calculated = true;
    }

    double getAggregate(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.values[0];
            }
            case 5: {
                return this.values[0] * (double)this.values.length;
            }
        }
        return Double.NaN;
    }

    void exportXml(XmlWriter xmlWriter) {
        xmlWriter.startTag("def");
        xmlWriter.writeTag("name", this.getName());
        xmlWriter.writeTag("datasource", this.defName);
        xmlWriter.writeTag("cf", this.consolFunc);
        xmlWriter.closeTag();
    }
}

