/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.DisposableSqlTypeValue;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.SqlTypeValue;

public abstract class StatementCreatorUtils {
    private static final Log logger = LogFactory.getLog((Class)StatementCreatorUtils.class);
    private static Map javaTypeToSqlTypeMap = new HashMap(32);

    public static int javaTypeToSqlParameterType(Class javaType) {
        Integer sqlType = (Integer)javaTypeToSqlTypeMap.get(javaType);
        if (sqlType != null) {
            return sqlType;
        }
        if (Number.class.isAssignableFrom(javaType)) {
            return 2;
        }
        if (StatementCreatorUtils.isStringValue(javaType)) {
            return 12;
        }
        if (StatementCreatorUtils.isDateValue(javaType) || Calendar.class.isAssignableFrom(javaType)) {
            return 93;
        }
        return Integer.MIN_VALUE;
    }

    public static void setParameterValue(PreparedStatement ps, int paramIndex, SqlParameter param, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(ps, paramIndex, param.getSqlType(), param.getTypeName(), param.getScale(), inValue);
    }

    public static void setParameterValue(PreparedStatement ps, int paramIndex, int sqlType, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(ps, paramIndex, sqlType, null, null, inValue);
    }

    public static void setParameterValue(PreparedStatement ps, int paramIndex, int sqlType, String typeName, Object inValue) throws SQLException {
        StatementCreatorUtils.setParameterValueInternal(ps, paramIndex, sqlType, typeName, null, inValue);
    }

    private static void setParameterValueInternal(PreparedStatement ps, int paramIndex, int sqlType, String typeName, Integer scale, Object inValue) throws SQLException {
        Calendar cal;
        String typeNameToUse = typeName;
        int sqlTypeToUse = sqlType;
        Object inValueToUse = inValue;
        if (inValue instanceof SqlParameterValue) {
            SqlParameterValue parameterValue = (SqlParameterValue)inValue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Overriding typeinfo with runtime info from SqlParameterValue: column index " + paramIndex + ", SQL type " + parameterValue.getSqlType() + ", Type name " + parameterValue.getTypeName()));
            }
            if (parameterValue.getSqlType() != Integer.MIN_VALUE) {
                sqlTypeToUse = parameterValue.getSqlType();
            }
            if (parameterValue.getTypeName() != null) {
                typeNameToUse = parameterValue.getTypeName();
            }
            inValueToUse = parameterValue.getValue();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting SQL statement parameter value: column index " + paramIndex + ", parameter value [" + inValueToUse + "], value class [" + (inValueToUse != null ? inValueToUse.getClass().getName() : "null") + "], SQL type " + (sqlTypeToUse == Integer.MIN_VALUE ? "unknown" : Integer.toString(sqlTypeToUse))));
        }
        if (inValueToUse == null) {
            if (sqlTypeToUse == Integer.MIN_VALUE) {
                boolean useSetObject = false;
                sqlTypeToUse = 0;
                try {
                    DatabaseMetaData dbmd = ps.getConnection().getMetaData();
                    String databaseProductName = dbmd.getDatabaseProductName();
                    String jdbcDriverName = dbmd.getDriverName();
                    if (databaseProductName.startsWith("Informix") || jdbcDriverName.startsWith("Apache Derby Embedded")) {
                        useSetObject = true;
                    } else if (databaseProductName.startsWith("DB2")) {
                        sqlTypeToUse = 12;
                    }
                }
                catch (Throwable ex) {
                    logger.debug((Object)"Could not check database or driver name", ex);
                }
                if (useSetObject) {
                    ps.setObject(paramIndex, null);
                } else {
                    ps.setNull(paramIndex, sqlTypeToUse);
                }
            } else if (typeNameToUse != null) {
                ps.setNull(paramIndex, sqlTypeToUse, typeNameToUse);
            } else {
                ps.setNull(paramIndex, sqlTypeToUse);
            }
        } else if (inValueToUse instanceof SqlTypeValue) {
            ((SqlTypeValue)inValueToUse).setTypeValue(ps, paramIndex, sqlTypeToUse, typeNameToUse);
        } else if (sqlTypeToUse == 12 || sqlTypeToUse == -1 || sqlTypeToUse == 2005 && StatementCreatorUtils.isStringValue(inValueToUse.getClass())) {
            ps.setString(paramIndex, inValueToUse.toString());
        } else if (sqlTypeToUse == 3 || sqlTypeToUse == 2) {
            if (inValueToUse instanceof BigDecimal) {
                ps.setBigDecimal(paramIndex, (BigDecimal)inValueToUse);
            } else if (scale != null) {
                ps.setObject(paramIndex, inValueToUse, sqlTypeToUse, (int)scale);
            } else {
                ps.setObject(paramIndex, inValueToUse, sqlTypeToUse);
            }
        } else if (sqlTypeToUse == 91) {
            if (inValueToUse instanceof java.util.Date) {
                if (inValueToUse instanceof Date) {
                    ps.setDate(paramIndex, (Date)inValueToUse);
                } else {
                    ps.setDate(paramIndex, new Date(((java.util.Date)inValueToUse).getTime()));
                }
            } else if (inValueToUse instanceof Calendar) {
                cal = (Calendar)inValueToUse;
                ps.setDate(paramIndex, new Date(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValueToUse, 91);
            }
        } else if (sqlTypeToUse == 92) {
            if (inValueToUse instanceof java.util.Date) {
                if (inValueToUse instanceof Time) {
                    ps.setTime(paramIndex, (Time)inValueToUse);
                } else {
                    ps.setTime(paramIndex, new Time(((java.util.Date)inValueToUse).getTime()));
                }
            } else if (inValueToUse instanceof Calendar) {
                cal = (Calendar)inValueToUse;
                ps.setTime(paramIndex, new Time(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValueToUse, 92);
            }
        } else if (sqlTypeToUse == 93) {
            if (inValueToUse instanceof java.util.Date) {
                if (inValueToUse instanceof Timestamp) {
                    ps.setTimestamp(paramIndex, (Timestamp)inValueToUse);
                } else {
                    ps.setTimestamp(paramIndex, new Timestamp(((java.util.Date)inValueToUse).getTime()));
                }
            } else if (inValueToUse instanceof Calendar) {
                cal = (Calendar)inValueToUse;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()), cal);
            } else {
                ps.setObject(paramIndex, inValueToUse, 93);
            }
        } else if (sqlTypeToUse == Integer.MIN_VALUE) {
            if (StatementCreatorUtils.isStringValue(inValueToUse.getClass())) {
                ps.setString(paramIndex, inValueToUse.toString());
            } else if (StatementCreatorUtils.isDateValue(inValueToUse.getClass())) {
                ps.setTimestamp(paramIndex, new Timestamp(((java.util.Date)inValueToUse).getTime()));
            } else if (inValueToUse instanceof Calendar) {
                cal = (Calendar)inValueToUse;
                ps.setTimestamp(paramIndex, new Timestamp(cal.getTime().getTime()));
            } else {
                ps.setObject(paramIndex, inValueToUse);
            }
        } else {
            ps.setObject(paramIndex, inValueToUse, sqlTypeToUse);
        }
    }

    private static boolean isStringValue(Class inValueType) {
        return CharSequence.class.isAssignableFrom(inValueType) || StringWriter.class.isAssignableFrom(inValueType);
    }

    private static boolean isDateValue(Class inValueType) {
        return java.util.Date.class.isAssignableFrom(inValueType) && !Date.class.isAssignableFrom(inValueType) && !Time.class.isAssignableFrom(inValueType) && !Timestamp.class.isAssignableFrom(inValueType);
    }

    public static void cleanupParameters(Object[] paramValues) {
        if (paramValues != null) {
            StatementCreatorUtils.cleanupParameters(Arrays.asList(paramValues));
        }
    }

    public static void cleanupParameters(Collection paramValues) {
        if (paramValues != null) {
            Iterator it = paramValues.iterator();
            while (it.hasNext()) {
                Object inValue = it.next();
                if (!(inValue instanceof DisposableSqlTypeValue)) continue;
                ((DisposableSqlTypeValue)inValue).cleanup();
            }
        }
    }

    static {
        javaTypeToSqlTypeMap.put(Boolean.TYPE, new Integer(16));
        javaTypeToSqlTypeMap.put(Boolean.class, new Integer(16));
        javaTypeToSqlTypeMap.put(Byte.TYPE, new Integer(4));
        javaTypeToSqlTypeMap.put(Byte.class, new Integer(4));
        javaTypeToSqlTypeMap.put(Short.TYPE, new Integer(4));
        javaTypeToSqlTypeMap.put(Short.class, new Integer(4));
        javaTypeToSqlTypeMap.put(Integer.TYPE, new Integer(4));
        javaTypeToSqlTypeMap.put(Integer.class, new Integer(4));
        javaTypeToSqlTypeMap.put(Long.TYPE, new Integer(4));
        javaTypeToSqlTypeMap.put(Long.class, new Integer(4));
        javaTypeToSqlTypeMap.put(BigInteger.class, new Integer(4));
        javaTypeToSqlTypeMap.put(Float.TYPE, new Integer(3));
        javaTypeToSqlTypeMap.put(Float.class, new Integer(3));
        javaTypeToSqlTypeMap.put(Double.TYPE, new Integer(3));
        javaTypeToSqlTypeMap.put(Double.class, new Integer(3));
        javaTypeToSqlTypeMap.put(BigDecimal.class, new Integer(3));
        javaTypeToSqlTypeMap.put(Date.class, new Integer(91));
        javaTypeToSqlTypeMap.put(Time.class, new Integer(92));
        javaTypeToSqlTypeMap.put(Timestamp.class, new Integer(93));
        javaTypeToSqlTypeMap.put(Blob.class, new Integer(2004));
        javaTypeToSqlTypeMap.put(Clob.class, new Integer(2005));
    }
}

