/*
 * Decompiled with CFR 0.152.
 */
package rath.msnm.msg;

import java.awt.Color;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Properties;
import rath.msnm.msg.MimeUtility;

public class MimeMessage {
    public static final int KIND_PROFILE = 0;
    public static final int KIND_TYPING_USER = 1;
    public static final int KIND_MESSAGE = 2;
    public static final int KIND_FILE_TRANSFER = 3;
    public static final int KIND_MAIL_NOTIFY = 4;
    public static final int KIND_UNKNOWN = 10;
    public static final String STR_PROFILE = "text/x-msmsgsprofile";
    public static final String STR_TYPING_USER = "text/x-msmsgscontrol";
    public static final String STR_MESSAGE = "text/plain";
    public static final String STR_FILE_TRANSFER = "text/x-msmsgsinvite";
    public static final String STR_MAIL_NOTIFY = "text/x-msmsgsinitialemailnotification";
    private int kind = 0;
    private String message = null;
    private String ef = "";
    private String fn = "\uad74\ub9bc";
    private Color fontColor = null;
    private Properties prop = new Properties();

    public MimeMessage() {
        this(null);
    }

    public MimeMessage(String message) {
        this.setMessage(message);
        this.fontColor = this.getRandomColor();
    }

    public MimeMessage(String message, Color fontColor) {
        this.setMessage(message);
        this.fontColor = fontColor;
        if (this.fontColor == null) {
            this.fontColor = this.getRandomColor();
        }
    }

    public MimeMessage(String message, Color fontColor, String font) {
        this.setMessage(message);
        this.fontColor = fontColor;
        this.fn = font;
        if (this.fontColor == null) {
            this.fontColor = this.getRandomColor();
        }
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public String getFontName() {
        return this.fn;
    }

    public void setFontName(String fn) {
        this.fn = fn;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color c) {
        this.fontColor = c;
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public String getMessage() {
        return this.message;
    }

    protected boolean addProperty(String line) {
        int i0 = line.indexOf(": ");
        if (i0 == -1) {
            return false;
        }
        String key = line.substring(0, i0);
        String value = line.substring(i0 + 2);
        this.prop.setProperty(key, value);
        return true;
    }

    public void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.prop;
    }

    public String getProperty(String key) {
        return this.prop.getProperty(key);
    }

    public boolean hasProperty(String key) {
        return this.prop.containsKey(key);
    }

    protected static void readLine(byte[] b, Unit unit) throws UnsupportedEncodingException {
        unit.line = null;
        for (int i = unit.mark; i < b.length; ++i) {
            if (b[i] != 10) continue;
            unit.line = new String(b, unit.mark, i - unit.mark - 1, "UTF-8");
            unit.mark = i + 1;
            return;
        }
        unit.mark = -1;
    }

    public static MimeMessage parse(byte[] raw) throws Exception {
        MimeMessage msg = new MimeMessage();
        Unit unit = new Unit();
        MimeMessage.readLine(raw, unit);
        msg.addProperty(unit.line);
        MimeMessage.readLine(raw, unit);
        msg.addProperty(unit.line);
        String contentType = msg.prop.getProperty("Content-Type");
        if (contentType.equals(STR_TYPING_USER)) {
            msg.kind = 1;
            MimeMessage.readLine(raw, unit);
            msg.addProperty(unit.line);
        } else if (contentType.startsWith(STR_PROFILE)) {
            msg.kind = 0;
            do {
                MimeMessage.readLine(raw, unit);
            } while (unit.line != null && msg.addProperty(unit.line));
        } else if (contentType.startsWith(STR_MAIL_NOTIFY)) {
            msg.kind = 4;
            while (true) {
                MimeMessage.readLine(raw, unit);
                if (unit.line != null) {
                    msg.addProperty(unit.line);
                    continue;
                }
                break;
            }
        } else if (contentType.startsWith(STR_FILE_TRANSFER)) {
            msg.kind = 3;
            do {
                MimeMessage.readLine(raw, unit);
            } while (unit.line != null && (unit.line.trim().length() == 0 || msg.addProperty(unit.line)));
        } else if (contentType.startsWith(STR_MESSAGE)) {
            msg.kind = 2;
            MimeMessage.readLine(raw, unit);
            if (unit.line.trim().length() > 0) {
                msg.addProperty(unit.line);
                MimeMessage.readLine(raw, unit);
            }
            msg.message = new String(raw, unit.mark, raw.length - unit.mark, "UTF-8");
        } else {
            msg.kind = 10;
            System.out.println("UNKNOWN-Content: " + contentType);
            msg.message = new String(raw, "UTF-8");
            System.out.println("Raw message: ");
            System.out.println("-------------------------------------------");
            System.out.println(raw);
            System.out.println("-------------------------------------------");
        }
        return msg;
    }

    private Color getRandomColor() {
        int r = (int)(Math.random() * 256.0);
        int g = (int)(Math.random() * 256.0);
        int b = (int)(Math.random() * 256.0);
        if (r > 160) {
            r = 160;
        }
        if (g > 160) {
            g = 160;
        }
        if (b > 160) {
            b = 160;
        }
        return new Color(r, g, b);
    }

    private String getStringAsColor(Color c) {
        return Integer.toHexString(c.getBlue() << 16 | c.getGreen() << 8 | c.getRed() << 0);
    }

    public String getEffectCode() {
        return this.ef;
    }

    public void setEffectCode(String ef) {
        this.ef = ef;
    }

    public byte[] getInstantMessageBytes() throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        sb.append("MIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\nX-MMS-IM-Format: FN=");
        sb.append(MimeUtility.getURLEncodedString(this.fn, "UTF-8"));
        sb.append("; EF=");
        sb.append(this.ef);
        sb.append("; CO=");
        sb.append(this.getStringAsColor(this.fontColor));
        sb.append("; CS=0; PF=22\r\n\r\n");
        sb.append(this.message);
        return sb.toString().getBytes("UTF-8");
    }

    public byte[] getTypingMessageBytes() throws UnsupportedEncodingException {
        StringBuffer sb = this.createMimeHeader(STR_TYPING_USER);
        sb.append("TypingUser: ");
        sb.append(this.message);
        sb.append("\r\n\r\n");
        return sb.toString().getBytes("UTF-8");
    }

    protected StringBuffer createMimeHeader(String header) {
        StringBuffer sb = new StringBuffer();
        sb.append("MIME-Version: 1.0\r\nContent-Type: ");
        sb.append(header);
        sb.append("\r\n");
        return sb;
    }

    protected StringBuffer fillMimeProperties(StringBuffer buf) {
        Enumeration<Object> e = this.prop.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = this.prop.getProperty(key);
            buf.append(key);
            buf.append(": ");
            buf.append(value);
            buf.append("\r\n");
        }
        buf.append("\r\n");
        return buf;
    }

    public byte[] getBytes() throws UnsupportedEncodingException {
        switch (this.kind) {
            case 2: {
                return this.getInstantMessageBytes();
            }
            case 1: {
                return this.getTypingMessageBytes();
            }
        }
        return null;
    }

    public static class Unit {
        int mark = 0;
        String line = null;
    }
}

