/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.util.LinkedList;
import org.videolan.BDJAction;
import org.videolan.BDJThreadGroup;
import org.videolan.BDJXletContext;
import org.videolan.Logger;
import org.videolan.PortingHelper;

public class BDJActionQueue
implements Runnable {
    private boolean terminated = false;
    private Thread thread;
    private LinkedList actions = new LinkedList();
    private static final Logger logger = Logger.getLogger(BDJActionQueue.class.getName());
    private Watchdog watchdog = null;

    public static BDJActionQueue create(String name) {
        return BDJActionQueue.create(null, name);
    }

    public static BDJActionQueue create(BDJThreadGroup threadGroup, String name) {
        BDJActionQueue aq = new BDJActionQueue(threadGroup, name);
        aq.startThread(threadGroup, name);
        return aq;
    }

    private BDJActionQueue(BDJThreadGroup threadGroup, String name) {
        if (threadGroup == null && BDJXletContext.getCurrentContext() != null) {
            logger.error("BDJActionQueue " + name + " created from wrong context: " + Logger.dumpStack());
        }
    }

    private void startThread(BDJThreadGroup threadGroup, String name) {
        this.thread = new Thread(threadGroup, this, name + ".BDJActionQueue");
        this.thread.setDaemon(true);
        this.thread.start();
        this.watchdog = new Watchdog();
        this.watchdog.start(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.actions;
        synchronized (linkedList) {
            this.terminated = true;
            this.actions.addLast(null);
            this.actions.notifyAll();
        }
        this.watchdog.shutdown();
        try {
            this.thread.join();
        }
        catch (InterruptedException t) {
            logger.error("Error joining thread: " + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object action;
            LinkedList linkedList = this.actions;
            synchronized (linkedList) {
                while (this.actions.isEmpty()) {
                    try {
                        this.actions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                action = this.actions.removeFirst();
            }
            if (action == null) {
                return;
            }
            try {
                this.watchdog.startAction(action);
                ((BDJAction)action).process();
                this.watchdog.endAction();
                continue;
            }
            catch (ThreadDeath d) {
                System.err.println("action failed: " + d + "\n");
                throw d;
            }
            catch (Throwable e) {
                System.err.println("action failed: " + e + "\n" + Logger.dumpStack(e));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(BDJAction action) {
        if (action != null) {
            LinkedList linkedList = this.actions;
            synchronized (linkedList) {
                if (!this.terminated) {
                    this.actions.addLast(action);
                    this.actions.notifyAll();
                } else {
                    logger.error("Action skipped (queue stopped): " + action);
                    action.abort();
                }
            }
        }
    }

    class Watchdog
    implements Runnable {
        private Object currentAction = null;
        private boolean terminate = false;

        Watchdog() {
        }

        synchronized void start(String name) {
            Thread t = new Thread(null, this, name + ".BDJActionQueue.Monitor");
            t.setDaemon(true);
            t.start();
        }

        public synchronized void shutdown() {
            this.terminate = true;
            this.notifyAll();
        }

        public synchronized void startAction(Object action) {
            this.currentAction = action;
            this.notifyAll();
        }

        public synchronized void endAction() {
            this.currentAction = null;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object loggedAction = null;
            Watchdog watchdog = this;
            synchronized (watchdog) {
                while (!this.terminate) {
                    if (loggedAction != null && this.currentAction != loggedAction) {
                        loggedAction = null;
                        logger.info("Callback returned (" + BDJActionQueue.this.thread + ")");
                    }
                    try {
                        if (this.currentAction == null) {
                            this.wait();
                            continue;
                        }
                        Object cachedAction = this.currentAction;
                        this.wait(5000L);
                        if (this.currentAction != cachedAction || loggedAction == cachedAction) continue;
                        logger.error("Callback timeout in " + BDJActionQueue.this.thread + ", callback=" + this.currentAction + "\n" + PortingHelper.dumpStack(BDJActionQueue.this.thread));
                        loggedAction = cachedAction;
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
        }
    }
}

