/*169:*/
//#line 10 "/usr/local/yacco2/library/thread.w"

/*565:*/
//#line 24 "/usr/local/yacco2/library/macros.w"



/*:565*/
//#line 11 "/usr/local/yacco2/library/thread.w"

/*26:*/
//#line 404 "/usr/local/yacco2/library/intro.w"

#include "yacco2.h"

/*:26*/
//#line 12 "/usr/local/yacco2/library/thread.w"

/*142:*/
//#line 137 "/usr/local/yacco2/library/wthread.w"

#if THREAD_LIBRARY_TO_USE__ == 1
/*:142*//*143:*/
//#line 144 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::CREATE_MUTEX(yacco2::MUTEX&Mu){
Mu= CreateMutex(0,OFF,0);
}
/*:143*//*144:*/
//#line 150 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::LOCK_MUTEX(yacco2::MUTEX&Mu){
WaitForSingleObject(Mu,INFINITE);
}
/*:144*//*145:*/
//#line 156 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::LOCK_MUTEX_OF_CALLED_PARSER
(yacco2::MUTEX&Mu,yacco2::Parser&parser,const char*Text){
/*606:*/
//#line 883 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 885 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" trying to acquire mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 889 "/usr/local/yacco2/library/macros.w"

}

/*:606*/
//#line 160 "/usr/local/yacco2/library/wthread.w"

WaitForSingleObject(Mu,INFINITE);
/*607:*/
//#line 893 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 895 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" acquired mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 899 "/usr/local/yacco2/library/macros.w"

}

/*:607*/
//#line 162 "/usr/local/yacco2/library/wthread.w"

}
/*:145*//*146:*/
//#line 165 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::UNLOCK_MUTEX(yacco2::MUTEX&Mu){
ReleaseMutex(Mu);
}
/*:146*//*147:*/
//#line 171 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::UNLOCK_MUTEX_OF_CALLED_PARSER
(yacco2::MUTEX&Mu,yacco2::Parser&parser,const char*Text){
/*608:*/
//#line 903 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 905 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" trying to release mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 909 "/usr/local/yacco2/library/macros.w"

}

/*:608*/
//#line 175 "/usr/local/yacco2/library/wthread.w"

ReleaseMutex(Mu);
/*609:*/
//#line 913 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 915 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" released mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 919 "/usr/local/yacco2/library/macros.w"

}

/*:609*/
//#line 177 "/usr/local/yacco2/library/wthread.w"

}

/*:147*//*148:*/
//#line 181 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::DESTROY_MUTEX(yacco2::MUTEX&Mu){
CloseHandle(Mu);
}
/*:148*//*149:*/
//#line 192 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::CREATE_COND_VAR(yacco2::COND_VAR&Cv){
COND_VAR xx= CreateSemaphore(0,0,1,0);
Cv= xx;
}
/*:149*//*150:*/
//#line 203 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::COND_WAIT(yacco2::COND_VAR&Cv,yacco2::MUTEX&Mu
,yacco2::Parser&parser){
/*648:*/
//#line 1552 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1554 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog
<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"
<<parser.thread_no__
<<"::"<<parser.thread_name()
<<" COND_WAIT entered into Wait on event "
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1561 "/usr/local/yacco2/library/macros.w"

}

/*:648*/
//#line 207 "/usr/local/yacco2/library/wthread.w"

UNLOCK_MUTEX_OF_CALLED_PARSER(Mu,parser," of self by COND_WAIT()");
WaitForSingleObject(Cv,INFINITE);
LOCK_MUTEX_OF_CALLED_PARSER(Mu,parser," of self from wakened COND_WAIT()");
/*649:*/
//#line 1565 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1567 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog
<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"<<parser.thread_no__
<<"::"<<parser.thread_name()
<<" COND_WAIT exit on event "
<<" cv_cond: "<<parser.cv_cond__
<<" no competing thds: "
<<parser.no_competing_pp_ths__
<<" no active thds: "
<<parser.from_thread__->th_active_cnt__
<<" from: "
<<parser.from_thread__->thread_no__<<"::"
<<parser.from_thread__->thread_name()
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1581 "/usr/local/yacco2/library/macros.w"

}

/*:649*/
//#line 211 "/usr/local/yacco2/library/wthread.w"

}
/*:150*//*151:*/
//#line 218 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::SIGNAL_COND_VAR(yacco2::Parser&To_thread,yacco2::Parser&parser){
/*650:*/
//#line 1585 "/usr/local/yacco2/library/macros.w"

clock_t start_;
if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
start_= clock();
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1589 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"
<<parser.thread_no__<<"::"<<parser.thread_name()
<<" to signal SIGNAL_COND_VAR: "
<<To_thread.thread_no__<<"::"<<To_thread.thread_name()
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1595 "/usr/local/yacco2/library/macros.w"

}

/*:650*/
//#line 221 "/usr/local/yacco2/library/wthread.w"

ReleaseSemaphore(To_thread.cv__,1,0);
/*651:*/
//#line 1599 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1601 "/usr/local/yacco2/library/macros.w"

clock_t stop_= clock();
yacco2::lrclog<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"
<<parser.thread_no__<<"::"<<parser.thread_name()
<<" after SIGNAL_COND_VAR : "<<stop_-start_
<<" to: "<<To_thread.thread_no__<<"::"
<<To_thread.thread_name()
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1609 "/usr/local/yacco2/library/macros.w"

}

/*:651*/
//#line 223 "/usr/local/yacco2/library/wthread.w"

}
/*:151*//*152:*/
//#line 226 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::DESTROY_COND_VAR(yacco2::COND_VAR&Cv){
CloseHandle(Cv);
}
/*:152*//*153:*/
//#line 250 "/usr/local/yacco2/library/wthread.w"

extern
yacco2::THR_result
yacco2::CREATE_THREAD(yacco2::Type_pp_fnct_ptr Thread
,yacco2::Parser&Parser_requesting_parallelism){
yacco2::THREAD_NO thread_no;
/*652:*/
//#line 1613 "/usr/local/yacco2/library/macros.w"

clock_t start_= clock();
if(yacco2::YACCO2_THP__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1616 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_THP__:: "
<<Parser_requesting_parallelism.thread_no__<<"::"
<<Parser_requesting_parallelism.thread_name()
<<" before CREATE_THREAD"
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1622 "/usr/local/yacco2/library/macros.w"

}

/*:652*/
//#line 256 "/usr/local/yacco2/library/wthread.w"

THR result= _beginthreadex(0,0,(Type_pp_fnct_ptr_voidp)Thread
,&Parser_requesting_parallelism,0,&thread_no);
/*653:*/
//#line 1626 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1628 "/usr/local/yacco2/library/macros.w"

clock_t stop_= clock();
yacco2::lrclog<<"YACCO2_THP__:: "
<<Parser_requesting_parallelism.thread_no__<<"::"
<<Parser_requesting_parallelism.thread_name()
<<" after CREATE_THREAD: "<<stop_-start_
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1635 "/usr/local/yacco2/library/macros.w"

}
//#line 1 "/usr/local/yacco2/library/notes.w"







/*:653*/
//#line 259 "/usr/local/yacco2/library/wthread.w"

return result;
}
/*:153*//*154:*/
//#line 263 "/usr/local/yacco2/library/wthread.w"

extern
yacco2::THREAD_NO yacco2::THREAD_SELF(){
return GetCurrentThreadId();
}

/*:154*//*155:*/
//#line 270 "/usr/local/yacco2/library/wthread.w"

#elif THREAD_LIBRARY_TO_USE__ == 0
/*:155*//*156:*/
//#line 285 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::CREATE_MUTEX(yacco2::MUTEX&Mu){
int result= pthread_mutex_init(&Mu,0);
}

/*:156*//*157:*/
//#line 292 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::LOCK_MUTEX(yacco2::MUTEX&Mu){
int result= pthread_mutex_lock(&Mu);
}

/*:157*//*158:*/
//#line 299 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::LOCK_MUTEX_OF_CALLED_PARSER
(yacco2::MUTEX&Mu,yacco2::Parser&parser,const char*Text){
/*606:*/
//#line 883 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 885 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" trying to acquire mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 889 "/usr/local/yacco2/library/macros.w"

}

/*:606*/
//#line 303 "/usr/local/yacco2/library/wthread.w"

int result= pthread_mutex_lock(&Mu);
/*607:*/
//#line 893 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 895 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" acquired mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 899 "/usr/local/yacco2/library/macros.w"

}

/*:607*/
//#line 305 "/usr/local/yacco2/library/wthread.w"

}

/*:158*//*159:*/
//#line 309 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::UNLOCK_MUTEX(yacco2::MUTEX&Mu){
int result= pthread_mutex_unlock(&Mu);
}

/*:159*//*160:*/
//#line 316 "/usr/local/yacco2/library/wthread.w"

extern
void
yacco2::UNLOCK_MUTEX_OF_CALLED_PARSER(yacco2::MUTEX&Mu
,yacco2::Parser&parser,const char*Text){
/*608:*/
//#line 903 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 905 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" trying to release mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 909 "/usr/local/yacco2/library/macros.w"

}

/*:608*/
//#line 321 "/usr/local/yacco2/library/wthread.w"

int result= pthread_mutex_unlock(&Mu);
/*609:*/
//#line 913 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 915 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MU_GRAMMAR__::"<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" released mutex"<<Text
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 919 "/usr/local/yacco2/library/macros.w"

}

/*:609*/
//#line 323 "/usr/local/yacco2/library/wthread.w"

}
/*:160*//*161:*/
//#line 326 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::DESTROY_MUTEX(yacco2::MUTEX&Mu){
int result= pthread_mutex_destroy(&Mu);
}
/*:161*//*162:*/
//#line 332 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::CREATE_COND_VAR(yacco2::COND_VAR&Cv){
pthread_cond_init(&Cv,0);
}
/*:162*//*163:*/
//#line 338 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::COND_WAIT(yacco2::COND_VAR&Cv,yacco2::MUTEX&Mu
,yacco2::Parser&parser){
/*648:*/
//#line 1552 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1554 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog
<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"
<<parser.thread_no__
<<"::"<<parser.thread_name()
<<" COND_WAIT entered into Wait on event "
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1561 "/usr/local/yacco2/library/macros.w"

}

/*:648*/
//#line 342 "/usr/local/yacco2/library/wthread.w"

if(yacco2::YACCO2_MU_GRAMMAR__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 344 "/usr/local/yacco2/library/wthread.w"

yacco2::lrclog<<parser.thread_no__<<"::"
<<parser.fsm_tbl__->id__<<"::"<<" before release mutex by pthread_cond_wait()"<<__FILE__<<__LINE__<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 347 "/usr/local/yacco2/library/wthread.w"

}
pthread_cond_wait(&Cv,&Mu);
/*649:*/
//#line 1565 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1567 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog
<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"<<parser.thread_no__
<<"::"<<parser.thread_name()
<<" COND_WAIT exit on event "
<<" cv_cond: "<<parser.cv_cond__
<<" no competing thds: "
<<parser.no_competing_pp_ths__
<<" no active thds: "
<<parser.from_thread__->th_active_cnt__
<<" from: "
<<parser.from_thread__->thread_no__<<"::"
<<parser.from_thread__->thread_name()
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1581 "/usr/local/yacco2/library/macros.w"

}

/*:649*/
//#line 350 "/usr/local/yacco2/library/wthread.w"

}
/*:163*//*164:*/
//#line 353 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::SIGNAL_COND_VAR(yacco2::Parser&To_thread,yacco2::Parser&parser){
/*650:*/
//#line 1585 "/usr/local/yacco2/library/macros.w"

clock_t start_;
if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
start_= clock();
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1589 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"
<<parser.thread_no__<<"::"<<parser.thread_name()
<<" to signal SIGNAL_COND_VAR: "
<<To_thread.thread_no__<<"::"<<To_thread.thread_name()
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1595 "/usr/local/yacco2/library/macros.w"

}

/*:650*/
//#line 356 "/usr/local/yacco2/library/wthread.w"

pthread_cond_signal(&To_thread.cv__);
/*651:*/
//#line 1599 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__||yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1601 "/usr/local/yacco2/library/macros.w"

clock_t stop_= clock();
yacco2::lrclog<<"YACCO2_THP__ || yacco2::YACCO2_MSG__::"
<<parser.thread_no__<<"::"<<parser.thread_name()
<<" after SIGNAL_COND_VAR : "<<stop_-start_
<<" to: "<<To_thread.thread_no__<<"::"
<<To_thread.thread_name()
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1609 "/usr/local/yacco2/library/macros.w"

}

/*:651*/
//#line 358 "/usr/local/yacco2/library/wthread.w"

}
/*:164*//*165:*/
//#line 361 "/usr/local/yacco2/library/wthread.w"

extern
void yacco2::DESTROY_COND_VAR(yacco2::COND_VAR&Cv){
pthread_cond_destroy(&Cv);
}
/*:165*//*166:*/
//#line 373 "/usr/local/yacco2/library/wthread.w"

extern
yacco2::THR_result
yacco2::CREATE_THREAD
(yacco2::Type_pp_fnct_ptr Thread,yacco2::Parser&Parser_requesting_parallelism){
/*652:*/
//#line 1613 "/usr/local/yacco2/library/macros.w"

clock_t start_= clock();
if(yacco2::YACCO2_THP__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1616 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_THP__:: "
<<Parser_requesting_parallelism.thread_no__<<"::"
<<Parser_requesting_parallelism.thread_name()
<<" before CREATE_THREAD"
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1622 "/usr/local/yacco2/library/macros.w"

}

/*:652*/
//#line 378 "/usr/local/yacco2/library/wthread.w"

yacco2::THREAD_NO thread_no;
pthread_attr_t alpha_attr;
pthread_attr_init(&alpha_attr);
#ifdef VMS__
pthread_attr_setstacksize(&alpha_attr,VMS_PTHREAD_STACK_SIZE__);
#endif
THR_result result= pthread_create(&thread_no,&alpha_attr
,(Type_pp_fnct_ptr_voidp)Thread,&Parser_requesting_parallelism);
pthread_detach(thread_no);
/*653:*/
//#line 1626 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_THP__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1628 "/usr/local/yacco2/library/macros.w"

clock_t stop_= clock();
yacco2::lrclog<<"YACCO2_THP__:: "
<<Parser_requesting_parallelism.thread_no__<<"::"
<<Parser_requesting_parallelism.thread_name()
<<" after CREATE_THREAD: "<<stop_-start_
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1635 "/usr/local/yacco2/library/macros.w"

}
//#line 1 "/usr/local/yacco2/library/notes.w"







/*:653*/
//#line 388 "/usr/local/yacco2/library/wthread.w"

return result;
}

/*:166*//*167:*/
//#line 393 "/usr/local/yacco2/library/wthread.w"

extern
yacco2::THREAD_NO yacco2::THREAD_SELF(){
return pthread_self();
}

/*:167*//*168:*/
//#line 400 "/usr/local/yacco2/library/wthread.w"

#endif
//#line 1 "/usr/local/yacco2/library/thread.w"








/*:168*//*174:*/
//#line 79 "/usr/local/yacco2/library/thread.w"

yacco2::Parallel_thread_tbl_type yacco2::Parallel_thread_table(MAX_NO_THDS);
yacco2::Parallel_thread_proc_call_table_type yacco2::Parallel_thread_proc_call_table[MAX_NO_THDS];

/*:174*//*175:*/
//#line 86 "/usr/local/yacco2/library/thread.w"

extern
yacco2::THR
_YACCO2_CALL_TYPE
yacco2::AR_for_manual_thread_spawning(yacco2::Parser*Caller_pp){
std::string ar_name("AR_yacco2");
/*30:*/
//#line 420 "/usr/local/yacco2/library/intro.w"

#include "war_begin_code.h"

/*:30*/
//#line 92 "/usr/local/yacco2/library/thread.w"

/*176:*/
//#line 107 "/usr/local/yacco2/library/thread.w"

if(Caller_pp->th_accepting_cnt__> 1){
char a[BUFFER_SIZE];

yacco2::KCHARP msg= 
"no arbitration code present in %s - accept token queue has %i > 1 tokens to arbitrate on";
sprintf(a,msg,ar_name.c_str(),Caller_pp->th_accepting_cnt__);
Yacco2_faulty_precondition(a,__FILE__,__LINE__);
exit(1);
}

/*:176*/
//#line 93 "/usr/local/yacco2/library/thread.w"

/*31:*/
//#line 424 "/usr/local/yacco2/library/intro.w"

#include "war_end_code.h"

/*:31*/
//#line 94 "/usr/local/yacco2/library/thread.w"

}


/*:175*//*177:*/
//#line 134 "/usr/local/yacco2/library/thread.w"

yacco2::worker_thread_blk::worker_thread_blk()
:grammar_s_parser__(0)
,status__(0),run_cnt__(1),thd_id__(0){
static bool init_gbl(OFF);
if(init_gbl==OFF){
init_gbl= ON;
CREATE_MUTEX(yacco2::TH_TBL_MU);
CREATE_MUTEX(yacco2::TRACE_MU);
CREATE_MUTEX(yacco2::TOKEN_MU);
CREATE_MUTEX(yacco2::SYM_TBL_MU);
}
}

/*:177*//*178:*/
//#line 156 "/usr/local/yacco2/library/thread.w"

yacco2::worker_thread_blk::worker_thread_blk(yacco2::Parser*Grammar_s_parser
,yacco2::Parser*Calling_parser)
:grammar_s_parser__(Grammar_s_parser)
,status__(THREAD_WAITING_FOR_WORK)
,run_cnt__(1)
,thd_id__(grammar_s_parser__->thread_entry__->thd_id__){
status__= THREAD_WORKING;
Parallel_thread_list_type&i= 
Parallel_thread_table[grammar_s_parser__->thread_entry__->thd_id__];
i.push_back(this);
/*618:*/
//#line 1047 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1049 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MSG__::"
<<this->grammar_s_parser__->thread_no__
<<"::"<<this->grammar_s_parser__->thread_name()
<<" th_blk*: "<<this
<<" pp this: "<<this->grammar_s_parser__
<<" this^pp^th_blk: "<<&this->grammar_s_parser__->th_blk__
<<"pp*: "<<grammar_s_parser__
<<"pp^th blk*: "<<&grammar_s_parser__->th_blk__
<<" #: "<<thd_id__
<<" thread created "
<<grammar_s_parser__->thread_no__
<<"::"<<grammar_s_parser__->thread_name()
<<" of grammar: "<<grammar_s_parser__->fsm_tbl__->id__
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1064 "/usr/local/yacco2/library/macros.w"

}

/*:618*/
//#line 167 "/usr/local/yacco2/library/thread.w"

}
/*:178*//*179:*/
//#line 175 "/usr/local/yacco2/library/thread.w"

void
yacco2::worker_thread_blk::set_waiting_for_work(){
/*616:*/
//#line 1006 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1008 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MSG__::"
<<this->grammar_s_parser__->thread_no__
<<"::"<<this->grammar_s_parser__->thread_name()
<<" th_blk*: "<<this
<<"this pp*: "<<this->grammar_s_parser__
<<"pp*: "<<grammar_s_parser__
<<"pp^th blk*: "<<&grammar_s_parser__->th_blk__
<<" #: "<<thd_id__
<<" st: "<<status__
<<" before setting waiting for work"
<<' '
<<grammar_s_parser__->thread_no__
<<"::"<<grammar_s_parser__->fsm_tbl__->id__
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1023 "/usr/local/yacco2/library/macros.w"

}

/*:616*/
//#line 178 "/usr/local/yacco2/library/thread.w"

status__= THREAD_WAITING_FOR_WORK;
/*617:*/
//#line 1027 "/usr/local/yacco2/library/macros.w"

if(yacco2::YACCO2_MSG__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 1029 "/usr/local/yacco2/library/macros.w"

yacco2::lrclog<<"YACCO2_MSG__::"
<<this->grammar_s_parser__->thread_no__
<<"::"<<this->grammar_s_parser__->thread_name()
<<" th_blk*: "<<this
<<"this pp*: "<<this->grammar_s_parser__
<<"pp*: "<<grammar_s_parser__
<<"pp^th blk*: "<<&grammar_s_parser__->th_blk__
<<" #: "<<thd_id__
<<" st: "<<status__
<<" after setting waiting for work "
<<grammar_s_parser__->thread_no__
<<"::"<<grammar_s_parser__->fsm_tbl__->id__
<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 1043 "/usr/local/yacco2/library/macros.w"

}

/*:617*/
//#line 180 "/usr/local/yacco2/library/thread.w"

}

/*:179*//*180:*/
//#line 197 "/usr/local/yacco2/library/thread.w"

extern void yacco2::Parallel_threads_shutdown(yacco2::Parser&PP){
/*380:*/
//#line 2829 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TH_TBL__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 2831 "/usr/local/yacco2/library/parser.w"

yacco2::lrclog<<" --> Attempting to acquire thread table Mutex"<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 2833 "/usr/local/yacco2/library/parser.w"

}
LOCK_MUTEX(yacco2::TH_TBL_MU);
if(yacco2::YACCO2_MU_TH_TBL__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 2837 "/usr/local/yacco2/library/parser.w"

yacco2::lrclog<<" --> Acquired thread table Mutex"<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 2839 "/usr/local/yacco2/library/parser.w"

}

/*:380*/
//#line 199 "/usr/local/yacco2/library/thread.w"

int no_thds_to_shutdown(0);
int no_ths_exited(0);
/*181:*/
//#line 214 "/usr/local/yacco2/library/thread.w"

#if THREAD_LIBRARY_TO_USE__ == 1
Sleep(1000);
#elif THREAD_LIBRARY_TO_USE__ == 0
sleep(1);
#endif

/*:181*/
//#line 202 "/usr/local/yacco2/library/thread.w"

/*182:*/
//#line 222 "/usr/local/yacco2/library/thread.w"

Parallel_thread_tbl_iterator_type k= Parallel_thread_table.begin();
Parallel_thread_tbl_iterator_type ke= Parallel_thread_table.end();
for(;k!=ke;++k){
Parallel_thread_list_iterator_type m= k->begin();
Parallel_thread_list_iterator_type me= k->end();
for(;m!=me;++m){
++no_thds_to_shutdown;
}
}
yacco2::lrclog<<"Number of threads in table to shutdown: "<<no_thds_to_shutdown<<__FILE__<<__LINE__<<std::endl;
k= Parallel_thread_table.begin();
for(;k!=ke;++k){
Parallel_thread_list_iterator_type m= k->begin();
Parallel_thread_list_iterator_type me= k->end();
for(;m!=me;++m){
worker_thread_blk*tb= *m;
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 239 "/usr/local/yacco2/library/thread.w"

yacco2::lrclog<<"worker task in table tb*: "<<tb
<<" thread id: "
<<tb->grammar_s_parser__->thread_no__
<<"::"<<tb->grammar_s_parser__->thread_name()
<<" run cnt: "<<tb->run_cnt__;
switch(tb->status__){
case THREAD_WAITING_FOR_WORK:{
yacco2::lrclog<<" waiting for work";
break;
}
case THREAD_WORKING:{
yacco2::lrclog<<" working";
break;
}
case THREAD_TO_EXIT:{
yacco2::lrclog<<" thread to exit";
break;
}
default:{
yacco2::lrclog<<" ??? thread status: "<<tb->status__;
break;
}
}
yacco2::lrclog<<__FILE__<<__LINE__<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 264 "/usr/local/yacco2/library/thread.w"

}
}


/*:182*/
//#line 203 "/usr/local/yacco2/library/thread.w"

/*183:*/
//#line 270 "/usr/local/yacco2/library/thread.w"

Parallel_thread_tbl_iterator_type i= Parallel_thread_table.begin();
Parallel_thread_tbl_iterator_type ie= Parallel_thread_table.end();
for(;i!=ie;++i){
Parallel_thread_list_iterator_type j= i->begin();
Parallel_thread_list_iterator_type je= i->end();
for(;j!=je;++j){
worker_thread_blk*tb= *j;
if(tb->status__==THREAD_WAITING_FOR_WORK){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 279 "/usr/local/yacco2/library/thread.w"

++no_ths_exited;
yacco2::lrclog<<"worker task to exit: "
<<tb->grammar_s_parser__->thread_no__
<<"::"<<tb->grammar_s_parser__->thread_name()
<<" tb* "<<tb
<<__FILE__<<__LINE__<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 286 "/usr/local/yacco2/library/thread.w"

LOCK_MUTEX_OF_CALLED_PARSER(tb->grammar_s_parser__->mu__
,*tb->grammar_s_parser__," of called thread");
tb->status__= THREAD_TO_EXIT;
PP.post_event_to_requesting_grammar(*tb->grammar_s_parser__,Shutdown,PP);
}
else{
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 293 "/usr/local/yacco2/library/thread.w"

yacco2::lrclog<<"worker task not shutting down: "
<<tb->grammar_s_parser__->thread_no__
<<"::"<<tb->grammar_s_parser__->thread_name()
<<" tb* "<<tb
<<" status: "<<tb->status__
<<__FILE__<<__LINE__<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 300 "/usr/local/yacco2/library/thread.w"

}
}
i->clear();
}
Parallel_thread_table.clear();
yacco2::lrclog<<"Number of threads in table exiting: "
<<no_ths_exited<<" number of threads not shutting down: "
<<no_thds_to_shutdown-no_ths_exited<<__FILE__<<__LINE__<<std::endl;


/*:183*/
//#line 204 "/usr/local/yacco2/library/thread.w"

/*181:*/
//#line 214 "/usr/local/yacco2/library/thread.w"

#if THREAD_LIBRARY_TO_USE__ == 1
Sleep(1000);
#elif THREAD_LIBRARY_TO_USE__ == 0
sleep(1);
#endif

/*:181*/
//#line 205 "/usr/local/yacco2/library/thread.w"

/*381:*/
//#line 2843 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TH_TBL__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 2845 "/usr/local/yacco2/library/parser.w"

yacco2::lrclog<<" --> Attempting to release thread table Mutex"<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 2847 "/usr/local/yacco2/library/parser.w"

}
UNLOCK_MUTEX(yacco2::TH_TBL_MU);
if(yacco2::YACCO2_MU_TH_TBL__){
/*389:*/
//#line 3053 "/usr/local/yacco2/library/parser.w"

LOCK_MUTEX(yacco2::TRACE_MU);
if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Acquired trace mu"<<FILE_LINE<<std::endl;
}

/*:389*/
//#line 2851 "/usr/local/yacco2/library/parser.w"

yacco2::lrclog<<" --> Released thread table Mutex"<<FILE_LINE<<std::endl;
/*390:*/
//#line 3060 "/usr/local/yacco2/library/parser.w"

if(yacco2::YACCO2_MU_TRACING__){
yacco2::lrclog<<"YACCO2_MU_TRACING__::Releasing trace mu"<<FILE_LINE<<std::endl;
}
UNLOCK_MUTEX(yacco2::TRACE_MU);

/*:390*/
//#line 2853 "/usr/local/yacco2/library/parser.w"

}

/*:381*/
//#line 206 "/usr/local/yacco2/library/thread.w"

DESTROY_MUTEX(yacco2::TH_TBL_MU);
DESTROY_MUTEX(yacco2::TRACE_MU);
DESTROY_MUTEX(yacco2::TOKEN_MU);
DESTROY_MUTEX(yacco2::SYM_TBL_MU);
}

/*:180*//*185:*/
//#line 353 "/usr/local/yacco2/library/thread.w"

yacco2::Caccept_parse::
Caccept_parse
(yacco2::Parser&Th_reporting_success
,yacco2::CAbs_lr1_sym&Accept_token
,yacco2::UINT Accept_token_pos
,yacco2::CAbs_lr1_sym&La_token
,yacco2::UINT La_token_pos){
th_reporting_success__= &Th_reporting_success;
accept_token__= &Accept_token;
accept_token_pos__= Accept_token_pos;
la_token__= &La_token;
la_token_pos__= La_token_pos;
}

yacco2::Caccept_parse::
Caccept_parse(){
th_reporting_success__= 0;
accept_token__= 0;
accept_token_pos__= 0;
la_token__= 0;
la_token_pos__= 0;
}
void yacco2::Caccept_parse::initialize_it(){
th_reporting_success__= 0;
accept_token__= 0;
accept_token_pos__= 0;
la_token__= 0;
la_token_pos__= 0;

}

void yacco2::Caccept_parse::fill_it(Caccept_parse&Accept_parse){
th_reporting_success__= Accept_parse.th_reporting_success__;
accept_token__= Accept_parse.accept_token__;
accept_token_pos__= Accept_parse.accept_token_pos__;
la_token__= Accept_parse.la_token__;
la_token_pos__= Accept_parse.la_token_pos__;
}

void yacco2::Caccept_parse::fill_it
(yacco2::Parser&Th_reporting_success
,yacco2::CAbs_lr1_sym&Accept_token
,yacco2::UINT Accept_token_pos
,yacco2::CAbs_lr1_sym&La_token
,yacco2::UINT La_token_pos){
th_reporting_success__= &Th_reporting_success;
accept_token__= &Accept_token;
accept_token_pos__= Accept_token_pos;
la_token__= &La_token;
la_token_pos__= La_token_pos;
}

yacco2::Caccept_parse::
~Caccept_parse(){
}

/*:185*//*212:*/
//#line 829 "/usr/local/yacco2/library/thread.w"

extern void yacco2::find_threads_by_first_set
(yacco2::USINT Current_T_id
,yacco2::yacco2_threads_to_run_type&Th_list
,yacco2::State_s_thread_tbl&P_tbl){
yacco2::thread_array_record*thds= (yacco2::thread_array_record*)yacco2::THDS_STABLE__;
/*213:*/
//#line 857 "/usr/local/yacco2/library/thread.w"

static int no_of_gbl_thds(0);
static int no_bit_mapped_words(0);
static bool one_time(false);
if(one_time==false){
one_time= true;
no_of_gbl_thds= thds->no_entries__;
div_t x= div(no_of_gbl_thds,BITS_PER_WORD);
if(x.rem!=0)++x.quot;
no_bit_mapped_words= x.quot;
}
if(P_tbl.thd_id_bit_map__==0){
/*215:*/
//#line 895 "/usr/local/yacco2/library/thread.w"

yacco2::Thread_entry**S_cur_thread_entry_ptr= (yacco2::Thread_entry**)&P_tbl.first_entry__;
yacco2::USINT S_no_thd_entries= P_tbl.no_entries__;

/*:215*/
//#line 869 "/usr/local/yacco2/library/thread.w"

yacco2::ULINT(*maps)= (yacco2::ULINT(*))yacco2::BIT_MAPS_FOR_SALE__;
P_tbl.thd_id_bit_map__= (yacco2::ULINT(*))&maps[yacco2::BIT_MAP_IDX__];
yacco2::BIT_MAP_IDX__+= no_bit_mapped_words;
if(yacco2::BIT_MAP_IDX__> yacco2::TOTAL_NO_BIT_WORDS__){
char a[BUFFER_SIZE];

yacco2::KCHARP msg= "Err no more bit maps: %i; adjust TOTAL_NO_BIT_WORDS in Linker";
sprintf(a,msg,yacco2::BIT_MAP_IDX__);
Yacco2_faulty_precondition(a,__FILE__,__LINE__);
exit(1);
}
div_t dd;
for(;S_no_thd_entries> 0;--S_no_thd_entries,++S_cur_thread_entry_ptr){
yacco2::USINT S_thd_id= (*S_cur_thread_entry_ptr)->thd_id__;
dd= div(S_thd_id,BITS_PER_WORD);
ULINT bit_pos_value= 1<<dd.rem;
P_tbl.thd_id_bit_map__[dd.quot]|= bit_pos_value;
}
}

/*:213*/
//#line 835 "/usr/local/yacco2/library/thread.w"

/*216:*/
//#line 900 "/usr/local/yacco2/library/thread.w"

yacco2::thd_ids_having_T*T_cur_thd_id_having_T_ptr;
yacco2::ULINT T_cur_thd_id_map;
T_array_having_thd_ids*t_array_having_thd_ids= 
(T_array_having_thd_ids*)yacco2::T_ARRAY_HAVING_THD_IDS__;
T_cur_thd_id_having_T_ptr= t_array_having_thd_ids->first_entry__[Current_T_id];
T_cur_thd_id_map= T_cur_thd_id_having_T_ptr->first_thd_id__[0];

/*:216*/
//#line 836 "/usr/local/yacco2/library/thread.w"

/*214:*/
//#line 891 "/usr/local/yacco2/library/thread.w"

yacco2::ULINT S_cur_thd_id_map= P_tbl.thd_id_bit_map__[0];

/*:214*/
//#line 837 "/usr/local/yacco2/library/thread.w"

/*217:*/
//#line 929 "/usr/local/yacco2/library/thread.w"

int base_idx_for_thd_id_calc(0);
int cur_bit_word_idx(0);
do{
yacco2::ULINT bit_map= T_cur_thd_id_map&S_cur_thd_id_map;
if(bit_map!=0){
base_idx_for_thd_id_calc= cur_bit_word_idx*BITS_PER_WORD;
/*218:*/
//#line 949 "/usr/local/yacco2/library/thread.w"

yacco2::ULINT bit(1);
for(int bit_pos= 0;bit_pos<=BITS_PER_WORD_REL_0;++bit_pos){
if(bit_map&bit){
/*219:*/
//#line 959 "/usr/local/yacco2/library/thread.w"

yacco2::USINT thd_id= base_idx_for_thd_id_calc+bit_pos;
Th_list.push_back(thds->first_entry__[thd_id]);

/*:219*/
//#line 953 "/usr/local/yacco2/library/thread.w"

}
bit<<= 1;
}

/*:218*/
//#line 936 "/usr/local/yacco2/library/thread.w"

}
++cur_bit_word_idx;
T_cur_thd_id_map= T_cur_thd_id_having_T_ptr->first_thd_id__[cur_bit_word_idx];
S_cur_thd_id_map= P_tbl.thd_id_bit_map__[cur_bit_word_idx];
}while(cur_bit_word_idx<no_bit_mapped_words);

/*:217*/
//#line 838 "/usr/local/yacco2/library/thread.w"

}

/*:212*/
//#line 13 "/usr/local/yacco2/library/thread.w"


/*:169*/
