/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  terminals_phrase.lex
Dates:		  24 May 2004
Purpose:	  terminals alphabet
Grammar being parsed:
	terminals       
	(file-name yacco2_terminals
	,name-space NS_yacco2_terminals)  
	{ 
        [terminals-refs code ***] optional
		1+ terminal definitions where def is
		 terminal-key [AD AB attributes] (sym-class C++ name)
		      or
		 terminal-key [AD AB attributes]
		 (sym-class C++ name {C++ directives block} ) 
        [terminals-sufx code ***] optional
	}
Note: The terminals-refs and terminals-sufx directives 
      bracket the emitted grammar code. Terminals-ref usually
      provides references for the terminals being defined.
      The terminals-sufx directive is an option for
      the grammar writer to append suffix code.
      
      Why is this pattern different than the other terminal
      classifications. Error terminals are basically indicators.
      Raw characters map the raw 8 bit character into its equivalent
      terminal token. The lrk constant terminals are just that
      constants. They indicate appropriate global intentions:
      end-of-file, end-of-grammar, and special meta terminals for
      parallel parsing --- |+|, ||| etc.
      
      Terminals are beyond the pedestrian classifications just mentioned.
      These are the specific terminals being designed by the grammar
      writer. They go beyond just the lexical and syntactical phases
      of compiling. One can designate any intent with appropriate
      behaviors. In fact, the Pascal translator to retarget Oregon
      Pascal and preproccessor language extensions to HP's Pascal
      built an extensive set of tree facitities that could be traversed
      with dynamic filters to create token containers. This allowed
      one to used grammars against trees to retarget the Pascal source code.
      It has been a thought of mine for many years to program in 
      grammars instead of procedural thoughts. One speaks in sentences 
      and not in the basic utterances of a stutter --- word: think procedure. 
      The filters provide tree node views in association with the
      the tree walker to sequential flatten forests of terminals.
      
      Grammars enhance the thought process with its nested actions
      accumlating in phrases. It does one thing well. It tells you
      when things are ambiguous.
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |terminals_phrase| grammar.\fbreak
Dispatcher to parse the terminals alphabet.
@/
fsm	
(fsm-id "terminals_phrase.lex"
,fsm-filename terminals_phrase
,fsm-namespace NS_terminals_phrase
,fsm-class Cterminals_phrase{
  user-prefix-declaration
#include "terminals_phrase_th.h"
#include "o2_externs.h"
  ***
  user-declaration
   public: yacco2::AST* cweb_marker__;
  ***
  op
   if(CWEB_MARKER != 0){
     cweb_marker__ = CWEB_MARKER;
     CWEB_MARKER=0;
   }
  ***
  constructor
   cweb_marker__ = 0;
  ***
}
,fsm-version "1.0",fsm-date "24 May 2004",fsm-debug "false"
,fsm-comments "Dispatcher to parse the terminals alphabet.")
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rterminals_phrase (){
  -> Rphrase
}

Rphrase (){
  ->  ||| "terminals-phrase" 
      NS_terminals_phrase_th::TH_terminals_phrase_th {
  op
    ADD_TOKEN_TO_PRODUCER_QUEUE(*sf->p2__);
  ***
  } 
  ->  ||| |?| NULL { // thread has stop parsing with RSVP error
  op
    ADD_TOKEN_TO_ERROR_QUEUE(*sf->p2__);
  ***
  }
  ->  |?| { // error due to no first set to start thread {
  op
    CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
    sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
    ADD_TOKEN_TO_ERROR_QUEUE(*sym);
  ***
  }
}
}// end of rules
