# xtem version is set here
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Univ. Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
###################################################################

set version "6.18"		;# sets xtem version
set version_incompatible "5.04"	;# sets .vst-file compatibility
set status ""			;# xtem status ("-alpha" | "-beta" | "")
set patches ""			;# xtem applied patches

proc setTclVersions {} {
 global vv tclversion patchlevel tclVersion addinput extended email www
 global NeedsMinimumTclOlderXtem NeedsMinimumTclThisXtem UpgradeRecommendedTclOlder
 global TestedUpToTcl SeemsToBeRunningTcl stt noWarnTcl

 set addinput [info command addinput]
 set extended [info command infox]
 set NeedsMinimumTclOlderXtem   7.0;  set XtemRunningWith 4.16
 set NeedsMinimumTclThisXtem    7.4;
 set UpgradeRecommendedTclOlder 7.4;
 set TestedUpToTcl              8.0;
 set SeemsToBeRunningTcl        8.0;
 set tclversion [info tclversion]; set patchlevel [info patchlevel]; # the "real version"
						# tclVersion is the "simulated version"

 if {($tclversion<$NeedsMinimumTclOlderXtem)} {

   # < 7.0:  will never run with this tcl version
   puts stdout \
	"xtem doesn't run with your old Tcl Version ($tclversion), see Installation Guide!"
   exit

 } elseif {($tclversion>=$NeedsMinimumTclOlderXtem)&&($tclversion<$NeedsMinimumTclThisXtem)} {

   puts stdout "This version of xtem presumes Tcl-version >= $NeedsMinimumTclThisXtem"
   puts stdout "yet there exists an older version of xtem running with your"
   puts stdout "Tcl/Tk version ($tclversion), see Installation Guide or README's!"
   exit

 } elseif {$tclversion<$UpgradeRecommendedTclOlder} {# upgrade of Tcl/Tk is recommended

   if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}$vv(xtq5)\n\n"
   }
   set tclVersion $tclversion

 } elseif {$tclversion<=$TestedUpToTcl} {# OK

   ### for {set i 0} {$i<=1} {incr i} {after 100; mybell 3}
   set tclVersion $tclversion

 } elseif {$tclversion<=$SeemsToBeRunningTcl} {# couldn't test it for myself with this Tcl/Tk!

   if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}$vv(xtq21) $tclversion $vv(xtq22)\n$vv(xtq23)\n$vv(xtq24)\n$www\n$email\n"
   }
   set tclVersion $TestedUpToTcl; mybell 1

 } else {#  no information

   if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}*** $vv(xtq21) $tclversion $vv(xtq22)\n$vv(xtq24):\n$www\n$email\n"
   }
   set tclVersion $TestedUpToTcl; mybell 4

 }
 
 global tk_patchLevel bindkeysenab bindkeys xtem_path;#####@@@@@ nur Tk4.2 --- tclversion
 if {($tk_patchLevel=="4.2")&($bindkeysenab==1)} {;#####@@@@@ nur Tk4.2 --- tclversion
   #foreach k [array names bindkeys] {;#####@@@@@ nur Tk4.2 --- tclversion
   #  if {[string first Alt-Key $bindkeys($k)]>=0} {;#####@@@@@ nur Tk4.2 --- tclversion
	#set stt "${stt}\n*****************************************************************"
	#set stt "${stt}\n* Your system administrator should apply Tk-Patch 4.2p2         *"
	#set stt "${stt}\n* to program Tcl/Tk/TclX. Otherwise all Alt-Key-bindings        *"
	#set stt "${stt}\n* (as used in xtem variable bindkeys($k) e.g.)                  *"
	#set stt "${stt}\n* will cause errors when used.                                  *"
	#set stt "${stt}\n* See file $xtem_path/README.Tk4.2p2" 
	#set stt "${stt}\n*****************************************************************\n"
	#break;#####@@@@@ nur Tk4.2 --- tclversion
   #  };#####@@@@@ nur Tk4.2 --- tclversion
   #};#####@@@@@ nur Tk4.2 --- tclversion
 };#####@@@@@ nur Tk4.2 --- tclversion
 
}
