#ifndef MACROS__H
#define MACROS__H

/*
** tr2latex - troff to LaTeX converter
** COPYRIGHT (C) 1987 Kamal Al-Yahya, 1991,1992 Christian Engel
**
** Module: macros.h
**
** This file contains the list of non-math macros and plain troff macros.
** Do NOT forget to put the dot for the troff macros, and the backslash
** for TeX macros (two backslashes, one for escape).
** The third column in the list is 0 for macros that have no arguments
** and either 1 or 2 for those that do. If it is 1, then only one line
** will be read as an argument. If it is 2, then lines will be read until
** properly terminated. Arguments for ms macros are terminated by an ms macro
** (e.g. .PP). Plain troff macros are terminated after reading the desired
** number of lines specified by the macro (e.g. .ce 5   will centerline 5
** lines). The fourth column specifies whether the macro implies a paragraph
** break (par > 1) or not (par = 0). This is needed to terminate some
** environments. If .LP, or .PP, par=1; if .IP, par=2; if .TP, par=3;
** if .QP, par=4.
*/

struct macro_table {
    const char *troff_mac, *tex_mac;
    int arg, macpar;
} macro[] = {
/*  troff macro     TeX macro       argument par    */
    { ".1C",    "\\onecolumn",          0,  1 },
    { ".2C",    "\\twocolumn",          0,  1 },
/*    ".AB",    "defined in program"			*/
    { ".AE",    "\\end{abstract}",      0,  1 },
    { ".AI",    "\\authoraff",          2,  1 },
    { ".AU",    "\\author",             2,  1 },
    { ".Ac",    "\\ACK",                0,  1 },
/*    ".B",     "defined in program"			*/
    { ".B1",    "\\boxit{",             0,  0 },
    { ".B2",    "}",                    0,  0 },
/*    ".BX",    "defined in program"			*/
    { ".DE",    "\\end{display}",       0,  0 },
/*  { ".DS",    "\\displaybegin",       0,  1 },*/
/*    ".ID",    "defined in program"			*/
    { ".LD",    "\\begin{display}[L]",  0,  1 },
    { ".CD",    "\\begin{display}[C]",  0,  1 },
    { ".BD",    "\\begin{display}[B]",  0,  1 },
/*    ".EF",    "defined in program"			*/
/*    ".EH",    "defined in program"			*/
/*    ".EN",    "defined in program"			*/
/*    ".EW",    "defined in program"			*/
    { ".FE",    "}",                    0,  0 },
    { ".FS",    "\\footnote{",          0,  0 },
/*    ".I",     "defined in program"			*/
    { ".Ic",    "\\caption{",           0,  1 },
    { ".Ie",    "}\\end{figure}",       0,  1 },
    { ".Is",    "\\begin{figure}",      0,  1 },
/*  { ".KE",    "defined in program"			*/
/*  { ".KF",    "defined in program"			*/
/*  { ".KS",    "defined in program"			*/
    { ".LG",    "\\LarGer",             0,  0 },
    { ".LP",    "\\par\\noindent",      0,  1 },
    { ".MH",    "\\mhead",              2,  1 },
    { ".ND",    "\\centerfoot",         1,  0 },
/*  { ".NH",    "defined in program",   1,  1 },*/
    { ".NL",    "\\NormaLfont",         0,  0 },
/*  { ".OH",    "defined in program"			*/
/*  { ".OF",    "defined in program"			*/
    { ".P1",    "\\thispagestyle{sep}", 0,  1 },
    { ".PP",    "\\par",                0,  1 },
    { ".PX",    "\\tableofcontents",    0,  1 },
    { ".QE",    "\\end{quotation}",     0,  1 },
/*  { ".QP",    "defined in program"			*/
    { ".QS",    "\\begin{quotation}",   0,  1 },
/*  { ".R",     "defined in program"			*/
/*  { ".RE",    "defined in program"			*/
/*  { ".RS",    "defined in program"			*/
    { ".SH",    "\\shead",              1,  1 },
    { ".SM",    "\\SMaller",            0,  0 },
    { ".TH",    "\\phead",              1,  0 },
    { ".TC",    "\\tableofcontents",    0,  1 },
    { ".TL",    "\\title",              2,  1 },
    { ".UC",    "",                     0,  0 },
    { ".UL",    "\\undertext",          1,  0 },
    { ".XP",    "\\XParagraph",         0,  1 },
    { ".XS",    "\\addcontensline{toc}{section}{", 0,  0 },
    { ".XA",    "}\n\\addcontensline{toc}{section}{", 0,  0 },
    { ".XE",    "{",                    0,  0 },
    { ".ad",    "\\adjust",             1,  1 },
    { ".bp",    "\\newpage",            0,  1 },
    { ".br",    "\\nwl",                0,  0 },
    { ".ce",    "\\cntr",               2,  0 },
    { ".cu",    "\\undertext",          2,  0 },
    { ".fi",    "\\fill",               0,  0 },
    { ".na",    "\\raggedright",        0,  0 },
    { ".nf",    "\\nofill",             0,  0 },
    { ".ns",    "",                     0,  0 },
    { ".ul",    "\\undertext",          2,  0 }
};

#endif
