/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.texparser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import net.sourceforge.texlipse.texparser.LatexLexer;
import net.sourceforge.texlipse.texparser.lexer.LexerException;
import net.sourceforge.texlipse.texparser.node.EOF;
import net.sourceforge.texlipse.texparser.node.TArgument;
import net.sourceforge.texlipse.texparser.node.TCchapter;
import net.sourceforge.texlipse.texparser.node.TCcite;
import net.sourceforge.texlipse.texparser.node.TCommentline;
import net.sourceforge.texlipse.texparser.node.TCparagraph;
import net.sourceforge.texlipse.texparser.node.TCpart;
import net.sourceforge.texlipse.texparser.node.TCsection;
import net.sourceforge.texlipse.texparser.node.TCssection;
import net.sourceforge.texlipse.texparser.node.TCsssection;
import net.sourceforge.texlipse.texparser.node.TOptargument;
import net.sourceforge.texlipse.texparser.node.TStar;
import net.sourceforge.texlipse.texparser.node.TWhitespace;
import net.sourceforge.texlipse.texparser.node.TWord;
import net.sourceforge.texlipse.texparser.node.Token;

public class LatexWordCounter {
    private String selection;

    public LatexWordCounter(String selection) {
        this.selection = selection;
    }

    public int countWords() {
        try {
            LatexLexer lexer = new LatexLexer(new PushbackReader(new StringReader(this.selection), 4096));
            int words = 0;
            boolean expectArg = false;
            Token t = lexer.next();
            while (!(t instanceof EOF)) {
                if (expectArg) {
                    if (t instanceof TArgument) {
                        words += t.getText().split("\\s+").length;
                        expectArg = false;
                    } else if (!(t instanceof TOptargument || t instanceof TWhitespace || t instanceof TStar || t instanceof TCommentline)) {
                        expectArg = false;
                    }
                } else if (t instanceof TWord || t instanceof TCcite) {
                    if (!"&".equals(t.getText())) {
                        ++words;
                    }
                } else if (!(t instanceof TWhitespace) && (t instanceof TCpart || t instanceof TCchapter || t instanceof TCsection || t instanceof TCssection || t instanceof TCsssection || t instanceof TCparagraph)) {
                    expectArg = true;
                }
                t = lexer.next();
            }
            return words;
        }
        catch (IOException iOException) {
            return -1;
        }
        catch (LexerException lexerException) {
            return -1;
        }
    }
}

