/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.HashMap;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class TexQuoteListener
implements IDocumentListener {
    private ITextEditor editor;
    private IDocument document;
    private static HashMap quotes;

    public TexQuoteListener(ITextEditor editor) {
        this.editor = editor;
        this.document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        if (quotes == null) {
            quotes = new HashMap();
            quotes.put("eno", "``");
            quotes.put("enc", "''");
            quotes.put("fio", "''");
            quotes.put("fic", "''");
            quotes.put("fro", "<<");
            quotes.put("frc", ">>");
            quotes.put("deo", "``");
            quotes.put("dec", "''");
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if ("\"".equals(event.getText())) {
            ITextSelection textSelection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
            try {
                char prev = this.document.getChar(textSelection.getOffset() - 1);
                String replacement = "\"";
                IProject project = ((FileEditorInput)this.editor.getEditorInput()).getFile().getProject();
                String lang = TexlipseProperties.getProjectProperty((IResource)project, "langSpell");
                if (Character.isWhitespace(prev)) {
                    replacement = (String)quotes.get(String.valueOf(lang) + "o");
                } else if (Character.isLetterOrDigit(prev)) {
                    replacement = (String)quotes.get(String.valueOf(lang) + "c");
                } else {
                    return;
                }
                this.document.removeDocumentListener((IDocumentListener)this);
                this.document.replace(textSelection.getOffset(), 1, replacement);
                this.document.addDocumentListener((IDocumentListener)this);
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

