/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.editor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.texlipse.TexlipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;

public class TexEditorTools {
    private static final Pattern simpleCommandPattern = Pattern.compile("\\\\([a-zA-Z]+)\\s*\\{(.*?)\\}\\s*");

    public int numberOfTabs(String text) {
        int count = 0;
        char[] array = text.toCharArray();
        if (array.length == 0) {
            return count;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == '\t') {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public int numberOfSpaces(String text) {
        int count = 0;
        char[] array = text.toCharArray();
        if (array.length == 0) {
            return count;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] != ' ') break;
            ++count;
            ++i;
        }
        return count;
    }

    public String getIndentation(String text, int tabWidth) {
        String indentation = "";
        char[] array = text.toCharArray();
        if (array.length == 0) {
            return indentation;
        }
        if (array[0] == ' ' || array[0] == '\t') {
            int tabs = this.numberOfTabs(text);
            int spaces = this.numberOfSpaces(text) - tabs + tabs * tabWidth;
            if (spaces > 0) {
                int i = 0;
                while (i < spaces) {
                    indentation = String.valueOf(indentation) + " ";
                    ++i;
                }
            }
        }
        return indentation;
    }

    public String getIndentation(IDocument document, int line, String text, int tabWidth) {
        String indentation = "";
        if (line == -1 || line >= document.getNumberOfLines()) {
            return indentation;
        }
        try {
            String lineText = document.get(document.getLineOffset(line), document.getLineLength(line));
            int beginIndex = lineText.indexOf(text);
            int tabs = this.numberOfTabs(lineText.substring(0, beginIndex));
            int spaces = beginIndex - tabs + tabs * tabWidth;
            if (spaces > 0) {
                int i = 0;
                while (i < spaces) {
                    indentation = String.valueOf(indentation) + " ";
                    ++i;
                }
            }
        }
        catch (Exception e) {
            TexlipsePlugin.log("TexEditorTools:getIndentation", e);
        }
        return indentation;
    }

    public String getEndLine(String text, String prefix) throws IndexOutOfBoundsException {
        String endOfLine = text.substring(prefix.length());
        return endOfLine.trim();
    }

    public String getEnvironment(String text) throws IndexOutOfBoundsException {
        int begin = text.indexOf(123);
        int end = text.indexOf(125);
        if (begin == 0 && end > begin) {
            return text.substring(begin + 1, end);
        }
        return "";
    }

    public int findMatchingBeginEquation(IDocument document, int line, String environment) throws BadLocationException {
        int startLine = line - 1;
        int startOffset = document.getLineOffset(startLine);
        int lineLength = document.getLineLength(startLine);
        String lineText = document.get(startOffset, lineLength).trim();
        boolean noMatch = true;
        int beginCounter = 0;
        int endCounter = 1;
        while (noMatch) {
            String end;
            if (lineText.startsWith("\\begin")) {
                end = this.getEndLine(lineText, "\\begin");
                if (this.getEnvironment(end).equals(environment) && ++beginCounter == endCounter) {
                    return startLine;
                }
            } else if (lineText.startsWith("\\end") && this.getEnvironment(end = this.getEndLine(lineText, "\\end")).equals(environment)) {
                ++endCounter;
            }
            if (startLine > 0) {
                startOffset = document.getLineOffset(--startLine);
                lineLength = document.getLineLength(startLine);
                lineText = document.get(startOffset, lineLength).trim();
                continue;
            }
            noMatch = false;
        }
        return -1;
    }

    public String getLineDelimiter(IDocument document, DocumentCommand command) {
        String delimiter = "\n";
        try {
            delimiter = document.getLineDelimiter(0);
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexEditorTools.getLineDelimiter: ", e);
        }
        return delimiter == null ? "\n" : delimiter;
    }

    public String getLineDelimiter(IDocument document) {
        return this.getLineDelimiter(document, null);
    }

    public int getLineLength(IDocument document, DocumentCommand command, boolean delim) {
        return this.getLineLength(document, command, delim, 0);
    }

    public int getLineLength(IDocument document, DocumentCommand command, boolean delim, int target) {
        int line;
        int length;
        block7: {
            block6: {
                length = 0;
                line = document.getLineOfOffset(command.offset) + target;
                if (line >= 0 && line < document.getNumberOfLines()) break block6;
                return 0;
            }
            length = document.getLineLength(line);
            if (length != 0) break block7;
            return 0;
        }
        try {
            if (!delim) {
                String txt = document.get(document.getLineOffset(line), document.getLineLength(line));
                String[] del = document.getLegalLineDelimiters();
                int cnt = TextUtilities.endsWith((String[])del, (String)txt);
                if (!delim && cnt > -1) {
                    length -= del[cnt].length();
                }
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexEditorTools.getLineLength:", e);
        }
        return length;
    }

    public String getStringAt(IDocument document, DocumentCommand command, boolean delim, int lineDif) {
        String line = "";
        try {
            int lineLength = delim ? this.getLineLength(document, command, true, lineDif) : this.getLineLength(document, command, false, lineDif);
            if (lineLength > 0) {
                int lineBegin = document.getLineOffset(document.getLineOfOffset(command.offset) + lineDif);
                line = document.get(lineBegin, lineLength);
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("TexEditorTools.getStringAt", e);
        }
        return line;
    }

    public String getStringAt(IDocument d, DocumentCommand c, boolean del) {
        return this.getStringAt(d, c, del, 0);
    }

    public int getLastWSPosition(String text, int limit) {
        int index = -1;
        if (text.length() >= limit && limit > -1) {
            int lastTab;
            String temp = text.substring(0, limit);
            int lastSpace = temp.lastIndexOf(32);
            index = lastSpace > (lastTab = temp.lastIndexOf(9)) ? lastSpace : lastTab;
        }
        return index;
    }

    public int getFirstWSPosition(String text, int limit) {
        int index = -1;
        if (text.length() > limit && limit > -1) {
            String temp = text.substring(limit + 1);
            int firstSpace = temp.indexOf(32);
            int firstTab = temp.indexOf(9);
            if (firstSpace == -1 && firstTab != -1) {
                index = firstTab + limit + 1;
            } else if (firstSpace != -1 && firstTab == -1) {
                index = firstSpace + limit + 1;
            } else if (firstSpace > -1 && firstTab > -1) {
                index = (firstSpace < firstTab ? firstSpace : firstTab) + limit + 1;
            }
        }
        return index;
    }

    public String trimBegin(String text) {
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            if (array[i] != ' ' && array[i] != '\t') break;
            ++i;
        }
        return text.substring(i);
    }

    public String trimEnd(String text) {
        char[] array = text.toCharArray();
        int i = array.length - 1;
        while (i >= 0) {
            if (array[i] != ' ' && array[i] != '\t') break;
            --i;
        }
        return text.substring(0, i + 1);
    }

    public boolean isLineCommandLine(String text) {
        String txt = text.trim();
        Matcher m = simpleCommandPattern.matcher(txt);
        return m.matches();
    }

    public boolean isLineCommentLine(String text) {
        return text.trim().startsWith("%");
    }

    public boolean isLineItemLine(String text) {
        return text.trim().startsWith("\\item");
    }

    public int getIndexOfComment(String line) {
        int p = 0;
        int n = line.length();
        while (p < n) {
            char c = line.charAt(p);
            if (c == '%') {
                return p;
            }
            if (c == '\\') {
                ++p;
            }
            ++p;
        }
        return -1;
    }

    public String getIndentationWithComment(String text) {
        StringBuffer indentation = new StringBuffer();
        char[] array = text.toCharArray();
        if (array.length == 0) {
            return indentation.toString();
        }
        int i = 0;
        while (i < array.length && (array[i] == ' ' || array[i] == '\t')) {
            indentation.append(array[i]);
            ++i;
        }
        if (i < array.length && array[i] == '%') {
            indentation.append("% ");
        }
        return indentation.toString();
    }

    public String getIndentation(String text) {
        StringBuffer indentation = new StringBuffer();
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length && (array[i] == ' ' || array[i] == '\t')) {
            indentation.append(array[i]);
            ++i;
        }
        return indentation.toString();
    }

    public String wrapWordString(String input, String indent, int width, String delim) {
        String[] words = input.split("\\s");
        if (input.length() == 0 || words.length == 0) {
            return "";
        }
        StringBuffer sbout = new StringBuffer(indent);
        sbout.append(words[0]);
        int currLength = indent.length() + words[0].length();
        int j = 1;
        while (j < words.length) {
            if (currLength + 1 + words[j].length() <= width) {
                sbout.append(" ");
                sbout.append(words[j]);
                currLength += 1 + words[j].length();
            } else {
                sbout.append(delim);
                sbout.append(indent);
                sbout.append(words[j]);
                currLength = indent.length() + words[j].length();
            }
            ++j;
        }
        sbout.append(delim);
        return sbout.toString();
    }

    public String[] getEnvCommandArg(String text) {
        String txt = text.trim();
        Matcher m = simpleCommandPattern.matcher(txt);
        while (m.find()) {
            if (!"begin".equals(m.group(1)) && !"end".equals(m.group(1))) continue;
            return new String[]{m.group(1), m.group(2)};
        }
        return new String[]{"", ""};
    }

    public String getNewlinesAtEnd(String text, String delim) {
        StringBuffer sb = new StringBuffer();
        int i = text.length() - delim.length();
        while (i >= 0) {
            if (!text.regionMatches(i, delim, 0, delim.length())) break;
            sb.append(delim);
            i -= delim.length();
        }
        return sb.toString();
    }
}

