/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.printing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterIOException;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.printing.Scaling;
import org.apache.pdfbox.rendering.PDFRenderer;

public final class PDFPrintable
implements Printable {
    private final PDDocument document;
    private final PDFRenderer renderer;
    private final boolean showPageBorder;
    private final Scaling scaling;
    private final float dpi;

    public PDFPrintable(PDDocument document) {
        this(document, Scaling.SHRINK_TO_FIT);
    }

    public PDFPrintable(PDDocument document, Scaling scaling) {
        this(document, scaling, false, 0.0f);
    }

    public PDFPrintable(PDDocument document, Scaling scaling, boolean showPageBorder) {
        this(document, scaling, showPageBorder, 0.0f);
    }

    public PDFPrintable(PDDocument document, Scaling scaling, boolean showPageBorder, float dpi) {
        this.document = document;
        this.renderer = new PDFRenderer(document);
        this.scaling = scaling;
        this.showPageBorder = showPageBorder;
        this.dpi = dpi;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex < 0 || pageIndex >= this.document.getNumberOfPages()) {
            return 1;
        }
        try {
            double scaleY;
            double scaleX;
            Graphics2D graphics2D = (Graphics2D)graphics;
            PDPage page = this.document.getPage(pageIndex);
            PDRectangle cropBox = PDFPrintable.getRotatedCropBox(page);
            double imageableWidth = pageFormat.getImageableWidth();
            double imageableHeight = pageFormat.getImageableHeight();
            double scale = 1.0;
            if (this.scaling != Scaling.ACTUAL_SIZE && (scale = Math.min(scaleX = imageableWidth / (double)cropBox.getWidth(), scaleY = imageableHeight / (double)cropBox.getHeight())) > 1.0 && this.scaling == Scaling.SHRINK_TO_FIT) {
                scale = 1.0;
            }
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics2D.translate((imageableWidth - (double)cropBox.getWidth() * scale) / 2.0, (imageableHeight - (double)cropBox.getHeight() * scale) / 2.0);
            Graphics2D printerGraphics = null;
            BufferedImage image = null;
            if (this.dpi > 0.0f) {
                float dpiScale = this.dpi / 72.0f;
                image = new BufferedImage((int)(imageableWidth * (double)dpiScale), (int)(imageableHeight * (double)dpiScale), 2);
                printerGraphics = graphics2D;
                graphics2D = image.createGraphics();
                printerGraphics.scale(scale / (double)dpiScale, scale / (double)dpiScale);
                scale = dpiScale;
            }
            AffineTransform transform = (AffineTransform)graphics2D.getTransform().clone();
            graphics2D.setBackground(Color.WHITE);
            this.renderer.renderPageToGraphics(pageIndex, graphics2D, (float)scale);
            if (this.showPageBorder) {
                graphics2D.setTransform(transform);
                graphics2D.setClip(0, 0, (int)imageableWidth, (int)imageableHeight);
                graphics2D.scale(scale, scale);
                graphics2D.setColor(Color.GRAY);
                graphics2D.setStroke(new BasicStroke(0.5f));
                graphics.drawRect(0, 0, (int)cropBox.getWidth(), (int)cropBox.getHeight());
            }
            if (printerGraphics != null) {
                printerGraphics.setBackground(Color.WHITE);
                printerGraphics.clearRect(0, 0, image.getWidth(), image.getHeight());
                printerGraphics.drawImage((Image)image, 0, 0, null);
                graphics2D.dispose();
            }
            return 0;
        }
        catch (IOException e) {
            throw new PrinterIOException(e);
        }
    }

    static PDRectangle getRotatedCropBox(PDPage page) {
        PDRectangle cropBox = page.getCropBox();
        int rotationAngle = page.getRotation();
        if (rotationAngle == 90 || rotationAngle == 270) {
            return new PDRectangle(cropBox.getLowerLeftY(), cropBox.getLowerLeftX(), cropBox.getHeight(), cropBox.getWidth());
        }
        return cropBox;
    }
}

