package ch.bfh.lpdg.datastructure;

import lombok.Getter;
import lombok.Setter;

import java.util.*;

@Getter
@Setter
public class Dependency {

    public boolean IsUnused;
    public String Source;

    private DependencyType type;
    private String name;
    private List<Dependency> dependencyList;

    public Dependency(DependencyType type, String name, String source) {
        this.type = type;
        this.name = name;
        this.dependencyList = new ArrayList<>();
        this.Source = source;
    }

    @Override
    public String toString() {
        return print(0);
    }

    private String print(int numTabs) {
        StringBuilder s = new StringBuilder(name + " (" + type.toString() + ")\n");

        for (Dependency d : dependencyList) {
            s.append("\t".repeat(numTabs + 1)).append(d.print(numTabs + 1));
        }

        return s.toString();
    }

    public String toLaTeXString() {
        return appendLine(0);
    }

    private String appendLine(int numTabs) {
        StringBuilder s = new StringBuilder(name + " (" + type.toString() + ")\n");

        for (Dependency d : dependencyList) {
            s.append("\t".repeat(numTabs + 1)).append(d.appendLine(numTabs + 1));
        }

        return s.toString();
    }

    public String toGraphString() {
        StringBuilder s = new StringBuilder();

        for (Dependency d : dependencyList) {
            var newStr = name.replace("\\", "").replace("@", "").replace(".", "").replace("-", "").replace("/", "");
            var newStrDep = d.name.replace("\\", "").replace("@", "").replace(".", "").replace("-", "").replace("/", "");
            s.append(newStr).append(" -> ").append(newStrDep).append(";\n");
            s.append(d.toGraphString());
        }

        return s.toString();
    }
}
