/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.lpdg;

import ch.bfh.lpdg.InteractionHandler;
import ch.bfh.lpdg.LatexHelper;
import ch.bfh.lpdg.datastructure.Dependency;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;

public class GraphHelper {
    public static final GraphHelper INSTANCE = new GraphHelper();
    private final InteractionHandler interactionHandler = InteractionHandler.getInstance();

    private GraphHelper() {
    }

    public static GraphHelper getInstance() {
        return INSTANCE;
    }

    public Path createFileForDependency(Dependency dependency, String outputPath) {
        String dependencyFileName = "dependencies_" + dependency.getName() + ".tex";
        String dependencyFilePath = outputPath + dependencyFileName;
        File dependencyFile = new File(outputPath + dependencyFileName);
        LatexHelper latexHelper = new LatexHelper();
        this.writeDependencyToFile(dependencyFile, dependency);
        boolean result = latexHelper.compileTempDocument(outputPath, dependencyFilePath);
        this.interactionHandler.printDebugMessage(String.valueOf(result));
        if (!this.generatePdfFromDotFile(outputPath + "dependencyGraph.dot")) {
            this.interactionHandler.printDebugMessage("Something went wrong trying to generate a pdf from the dot file.");
        }
        boolean result2 = latexHelper.compileTempDocument(outputPath, dependencyFilePath);
        this.interactionHandler.printDebugMessage(String.valueOf(result2));
        return dependencyFile.toPath();
    }

    private void writeDependencyToFile(File file, Dependency dependency) {
        try {
            String dependencyList = dependency.toLaTeXString();
            String graphString = dependency.toGraphString();
            String truncatedGraphString = this.truncateGraphString(graphString);
            String reorganizedGraphString = this.reorganizeGraphString(truncatedGraphString);
            BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);
            writer.write("\\documentclass{article}\n\\usepackage[pdf]{graphviz}\n\\usepackage{pdflscape}\n\\begin{document}\n\\begin{verbatim}\n");
            writer.write(dependencyList);
            writer.write("\\end{verbatim}\n");
            if (dependency.getDependencyList().size() != 0) {
                writer.write("\\pagebreak\n");
                writer.write("\\begin{landscape}\n");
                writer.write("\\digraph{dependencyGraph}{\n");
                writer.write("\tnewrank=true;\n\t");
                writer.write("\trank=\"same\";\n\t");
                writer.write("\trankdir=TB;\n\t");
                writer.write("\tratio=\"fill\";\n\t");
                writer.write("\tsize=\"8.3,11.7!\";\n\t");
                writer.write("\tmargin=0;\n\t");
                writer.write(reorganizedGraphString);
                writer.write("}\n");
                writer.write("\\end{landscape}\n");
            }
            writer.write("\\end{document}\n");
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Error in the temporary file: " + e);
        }
    }

    private String truncateGraphString(String graphString) {
        StringBuilder builder = new StringBuilder();
        for (String line : new LinkedHashSet<String>(Arrays.asList(graphString.split("\n")))) {
            builder.append(line).append("\n");
        }
        return builder.toString();
    }

    private String reorganizeGraphString(String graphString) {
        String rightNode;
        String[] parts;
        StringBuilder result = new StringBuilder();
        String[] lines = graphString.split("\n");
        LinkedHashMap<String, Integer> lastOccurrences = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.isEmpty()) continue;
            parts = line.split(" -> ");
            rightNode = parts[1].substring(0, parts[1].indexOf(59)).trim();
            lastOccurrences.put(rightNode, i);
        }
        Iterator i = lastOccurrences.values().iterator();
        while (i.hasNext()) {
            int i2 = (Integer)i.next();
            result.append(lines[i2]).append("\n");
        }
        for (int i3 = 0; i3 < lines.length; ++i3) {
            String line = lines[i3].trim();
            if (line.isEmpty() || i3 == (Integer)lastOccurrences.get(rightNode = (parts = line.split(" -> "))[1].substring(0, parts[1].indexOf(59)).trim())) continue;
            result.append(lines[i3]).append("\n");
        }
        return result.toString();
    }

    private boolean generatePdfFromDotFile(String dependencyGraphPath) {
        try {
            List<String> cmd = Arrays.asList("dot", "-Tpdf", "-o", dependencyGraphPath.replace("dot", "pdf"), dependencyGraphPath);
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            int res = process.waitFor();
            return res == 0;
        }
        catch (Exception e) {
            System.err.println("Error while compiling the dot file to pdf: " + e);
            return false;
        }
    }
}

