/*
 * Decompiled with CFR 0.152.
 */
package ch.bfh.lpdg;

import ch.bfh.lpdg.InteractionHandler;
import ch.bfh.lpdg.datastructure.Dependency;
import ch.bfh.lpdg.datastructure.DependencyType;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class DependencyScanner {
    public static final String REGEX_DEPENDENCIES = "\\u005Cusepackage\\{(.*?)}|\\u005CRequirePackage\\{(.*?)}|\\u005Cinput\\{(.*?)}|\\u005Cinclude\\{(.*?)}";
    public static final DependencyScanner INSTANCE = new DependencyScanner();
    private String filePathWithoutFileName;

    private DependencyScanner() {
    }

    public static DependencyScanner getInstance() {
        return INSTANCE;
    }

    public Dependency findDependencies(String filePath, DependencyType type, String source, List<String> alreadyAddedDependencies, int scanDepth) {
        String fileName = Paths.get(filePath, new String[0]).getFileName().toString();
        String fileNameWithoutExt = this.resolveDependencyName(fileName);
        this.filePathWithoutFileName = String.copyValueOf(filePath.toCharArray());
        this.filePathWithoutFileName = this.filePathWithoutFileName.replace(fileName, "");
        Dependency dependency = new Dependency(type, fileNameWithoutExt, source);
        if (scanDepth > 0) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filePath)));
                Pattern pattern = Pattern.compile(REGEX_DEPENDENCIES);
                while ((line = br.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    while (matcher.find()) {
                        String usepackage = matcher.group(1);
                        String requirepackage = matcher.group(2);
                        String input = matcher.group(3);
                        String include = matcher.group(4);
                        List<Dependency> extractedUP = this.extractDependencies(usepackage, DependencyType.USE_PACKAGE, matcher.group(0), alreadyAddedDependencies, scanDepth);
                        List<Dependency> extractedRP = this.extractDependencies(requirepackage, DependencyType.REQUIRE_PACKAGE, matcher.group(0), alreadyAddedDependencies, scanDepth);
                        List<Dependency> extractedINP = this.extractDependencies(input, DependencyType.INPUT, matcher.group(0), alreadyAddedDependencies, scanDepth);
                        List<Dependency> extractedINC = this.extractDependencies(include, DependencyType.INCLUDE, matcher.group(0), alreadyAddedDependencies, scanDepth);
                        List extractedDependencies = Stream.of(extractedUP, extractedRP, extractedINP, extractedINC).filter(Objects::nonNull).flatMap(Collection::stream).toList();
                        extractedDependencies.forEach(dep -> dependency.getDependencyList().add((Dependency)dep));
                    }
                }
                br.close();
            }
            catch (FileNotFoundException ex) {
                InteractionHandler.getInstance().printDebugMessage("File: " + fileName + " was not found.");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        List<Dependency> cleanDependencies = this.removeInvalidDependencies(dependency);
        dependency.setDependencyList(cleanDependencies);
        return dependency;
    }

    private List<Dependency> extractDependencies(String dependencyName, DependencyType type, String source, List<String> alreadyAddedDependencies, int scanDepth) {
        ArrayList<String> currentDependencies = new ArrayList<String>(alreadyAddedDependencies);
        if (dependencyName != null && !dependencyName.isEmpty()) {
            if (dependencyName.contains(",")) {
                String[] packages = dependencyName.split(",");
                ArrayList<Dependency> foundDependencies = new ArrayList<Dependency>();
                Arrays.stream(packages).forEach(p -> {
                    if (!currentDependencies.contains(p)) {
                        String filePath = this.resolvePath((String)p, type);
                        if (filePath == null) {
                            foundDependencies.add(new Dependency(type, (String)p, source));
                        } else {
                            currentDependencies.add((String)p);
                            Dependency dependency = this.findDependencies(filePath, type, source, currentDependencies, scanDepth - 1);
                            if (dependency != null) {
                                foundDependencies.add(dependency);
                            }
                        }
                    }
                });
                return foundDependencies;
            }
            if (!alreadyAddedDependencies.contains(dependencyName)) {
                String filePath = this.resolvePath(dependencyName, type);
                if (filePath == null) {
                    return Collections.singletonList(new Dependency(type, dependencyName, source));
                }
                currentDependencies.add(dependencyName);
                return List.of(this.findDependencies(filePath, type, source, currentDependencies, scanDepth - 1));
            }
        }
        return Collections.emptyList();
    }

    private String resolvePath(String packageName, DependencyType type) {
        Process process;
        try {
            boolean hasExtension = packageName.lastIndexOf(46) != -1;
            process = Runtime.getRuntime().exec(String.format("kpsewhich %s%s", packageName, hasExtension ? "" : ".sty"));
        }
        catch (IOException e) {
            System.err.println("Couldn't execute kpsewhich command.");
            throw new RuntimeException(e);
        }
        StringBuilder result = new StringBuilder();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while (true) {
            String s;
            try {
                s = stdInput.readLine();
                if (s == null) {
                    break;
                }
            }
            catch (IOException e) {
                System.err.println("Couldn't read output of kpsewhich command.");
                throw new RuntimeException(e);
            }
            result.append(s);
        }
        if (result.isEmpty()) {
            if (type.equals((Object)DependencyType.INCLUDE) || type.equals((Object)DependencyType.INPUT)) {
                return this.filePathWithoutFileName + packageName + ".tex";
            }
            return null;
        }
        return Paths.get(result.toString(), new String[0]).toAbsolutePath().toString();
    }

    private List<Dependency> removeInvalidDependencies(Dependency d) {
        return d.getDependencyList().stream().filter(e -> !e.getName().contains("#") && !e.getName().contains("@")).toList();
    }

    private String resolveDependencyName(String fileName) {
        return fileName.split("\\.")[0];
    }
}

