/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.PageSize;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfReader;
import de.nm.ant.AbstractSrcDestTask;
import de.nm.string.XString;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;

public abstract class AbstractPdfTask
extends AbstractSrcDestTask {
    protected String pwowner = null;
    protected char version = (char)53;

    protected Rectangle createEmptyPage(String pagesize, boolean landscape) {
        if (pagesize == null) {
            return PageSize.A4;
        }
        Rectangle p = PageSize.getRectangle((String)pagesize);
        if (landscape) {
            p = p.rotate();
        }
        return p;
    }

    protected PdfReader createPdfReader() throws IOException {
        return this.createPdfReader(this.workdir);
    }

    protected PdfReader createPdfReader(File dir) throws IOException {
        return this.createPdfReader(dir, "pdf");
    }

    protected PdfReader createPdfReader(File dir, String ext) throws IOException {
        File pdf = this.createFile(dir, XString.concat((String[])new String[]{this.basename, ".", ext}));
        if (!pdf.exists()) {
            throw new FileNotFoundException(pdf.getAbsolutePath());
        }
        InputStream in = this.createInputStream(pdf);
        if (this.pwowner == null) {
            return new PdfReader(in);
        }
        return new PdfReader(in, this.pwowner.getBytes());
    }

    protected PdfReader createPdfReaderFromFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        InputStream in = this.createInputStream(file);
        if (this.pwowner == null) {
            return new PdfReader(in);
        }
        return new PdfReader(in, this.pwowner.getBytes());
    }

    protected File getOutputFile(String number, String ext) {
        if (this.workdir == null) {
            throw new BuildException("'workdir' not set!");
        }
        if (this.basename == null) {
            throw new BuildException("'basename' not set!");
        }
        return this.createFile(this.workdir, this.createOutname() + number, ext);
    }

    public void setPwowner(String pwowner) {
        this.pwowner = pwowner;
    }

    public void setVersion(char version) {
        this.version = version;
    }
}

