% Klassendatei fr Privatbriefe
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{privat}
\RequirePackage{ifthen}

%  Zwei Personen koennen sich beteiligen
\newboolean{max}     \setboolean{max}{false}
\newboolean{verena}  \setboolean{verena}{false}

\DeclareOption{max}{\setboolean{max}{true}}
\DeclareOption{verena}{\setboolean{verena}{true}}
\DeclareOption*
  {\PassOptionsToClass{\CurrentOption}{letter}}

%  Max schreibt hufiger -> Voreinstellung
\ExecuteOptions{max}
\ProcessOptions\relax

%  Alle mgen A4-Papier und die deutsche Anpassung
\LoadClass[a4paper,12pt]{letter}
\RequirePackage{german}

\renewcommand\opening[1]{
  \thispagestyle{firstpage}%
  % Falzmarken
  {\unitlength1cm\begin{picture}(0,0)
    \put(-1.5,-6.45){\line(1,0){.5}}
    \put(-1.5,-16.36){\line(1,0){.5}}
  % Empfngerfeld  auf richtige Hhe verschieben
    \put(0,-2){\parbox[t][35mm][s]{\textwidth}
           {\underline{\footnotesize\@returnaddress}
            \vfil\raggedright \toname\\ 
            \toaddress\vfil}}
  \end{picture}}
  \vspace{0pt plus.00006fil}
  \rightline{\hfil\@location, den \datebox}\par
  \ifthenelse{\equal{\refboxtext}{}}
    {}{\showrefbox\par}
  \vspace{2\parskip}
  #1\par\nobreak}

\long\def\closing#1{\par\nobreak\vspace{\parskip}%
  \stopbreaks
  #1\par\vspace{3\parskip}
  \ifthenelse{\equal{\fromsig}{}}
    {}{\fromsig\par}
  }

\newcommand{\showrefbox}
  {\underline{Betrifft: \refboxtext}}
\newcommand{\refbox}[1]
  {\renewcommand{\refboxtext}{#1}}
\renewcommand{\signature}[1]
  {\renewcommand{\fromsig}{#1}}
\renewcommand{\date}[1]
  {\renewcommand{\datebox}{#1}}
\newcommand{\street}[1]
  {\renewcommand{\@street}{#1}}
\renewcommand{\location}[1]
  {\renewcommand{\@location}{#1}}
\renewcommand{\telephone}[1]
  {\renewcommand{\@telephone}{#1}}
\newcommand{\city}[1]
  {\renewcommand{\@city}{#1}}   
\renewcommand{\name}[1]
  {\renewcommand{\fromname}{#1}}
\newcommand{\return}[1]
  {\renewcommand{\@returnaddress}{#1}}

% Voreinstellungen
\ifthenelse{\boolean{verena}}
  {\renewcommand{\fromname}{Verena Bauer}}
  {\renewcommand{\fromname}{Max Bauer}}
\newcommand{\refboxtext}{}
\renewcommand{\fromsig}{}
\newcommand{\datebox}{\@date}
\newcommand{\@street}{Raubergasse 15}
\newcommand{\@telephone}{Tel. (0361) 88 04 34}
\newcommand{\@city}{A-8010 Graz}
\newcommand{\@location}{Graz}
\newcommand{\@returnaddress}
  {\fromname\ \@street\ \@city}

\setlength{\headsep}{30pt}
\renewcommand{\@texttop}{}

\renewcommand{\thepage}{- \arabic{page}\ -}

\renewcommand{\ps@headings}{
   \renewcommand{\@oddhead}
     {\vbox to \textwidth{\footnotesize\it 
      \headtoname\ \toname\hfil 
      \@date\hfil \pagename\ \thepage\\
      \vskip2pt\hrule height .5pt}}
   \renewcommand{\@oddfoot}
     {\footnotesize\fromname\hfil\@street\hfil
      \@telephone\hfil\@city}}
\pagestyle{headings}

\renewcommand{\ps@firstpage}{
   \setlength{\topmargin}{-57pt}
   \setlength{\headheight}{52pt}
   \ifthenelse{\boolean{max}}
     {\renewcommand{\@oddhead}
        {\parbox{\textwidth}
           {\centering{\sc \fromname}\\
            {\footnotesize \@street\\ \@city}}}}
     {\renewcommand{\@oddhead}
        {\parbox{\textwidth}
          {{\sc \fromname}\\
            {\small \@street\\ \@city\\ \@telephone}}}}
   \renewcommand{\@oddfoot}{}
   \renewcommand{\@evenhead}{}
   \renewcommand{\@evenfoot}{}}