---
myst:
  html_meta:
    keywords: mise en page de documents,autres projets,à partir de TeX,dérivés de LaTeX
---
# Existe-t-il des projets dérivés de TeX ?

## kerTeX

[kerTeX](https://kertex.kergis.com/fr/index.html) est une distribution TeX minimaliste visant à pouvoir s'installer sur tous les systèmes informatiques, même dans des environnements extrêmement restreints. Le projet est mené par [Thierry Laronde](http://kertex.kergis.com/fr/contacts.html), et son code spécifique est diffusé sous licence BSD.

Voir la question « [](/6_distributions/installation/kertex) »

En pratique, d'après ses auteurs, il n'a besoin que d'une bibliothèque
C standard (`libc`) pour fonctionner. Il embarque son propre système de gestion
des extensions.

## Tectonic typesetting

[Tectonic](https://tectonic-typesetting.github.io/) se veut un moteur TeX modernisé et complet, basé sur XeTeX et TeX Live. Il est constitué d'une unique bibliothèque, contenant tout ce qui est nécessaire. Par rapport au moteur TeX usuel, il a la particularité de ne pas produire de fichiers intermédiaires, et de délivrer le document final en une seule exécution.

Le projet est [en développement sur GitHub](https://github.com/tectonic-typesetting/tectonic/), sous licence MIT.

:::{note}
Le projet revendique d'orthographier son nom de façon simple, avec un `C` (Te**c**tonic), par opposition à la complexité de [l'orthographe et la prononciation](/1_generalites/bases/comment_prononcer_tex) de TeX.
:::

## KaTeX

[KaTeX](https://katex.org/) est une bibliothèque logicielle destinée à afficher des formules mathématiques dans les navigateurs web. La syntaxe et la mise en forme suivent les principes de TeX mais il s'agit d'une réimplémentation en Javascript d'un sous-ensemble limité de fonctionnalités du moteur TeX standard.

[MathJax](wpfr:MathJax) a le même usage, et implémente un nombre plus grand de fonctionnalités que KaTeX.

Pour plus d'informations :

- [KaTeX sur Wikipedia](wp:KaTeX) (en anglais),
- [TeX as a three-stage rocket : Cookie-cutterpage breaking](https://tug.org/TUGboat/tb36-2/tb113venkatesan.pdf), TUGboat, Volume 36 (2015), n{sup}`o`2.

```{image} https://www.speedata.de/images/logo-int.png
:alt: https://www.speedata.de/images/logo-int.png
:class: align-top
:width: 180px
```

## Speedata Publisher

[Speedata Publisher](https://www.speedata.de/en/) est un programme de composition entièrement automatisée qui utilise [LuaTeX](/1_generalites/glossaire/luatex) pour toute la partie interne du traitement du document. L'utilisateur fournit deux fichiers XML : l'un contient les données, l'autre est une feuille de style écrite dans un langage propre à Speedata. L'exécutable `sp` applique la feuille de style au fichier de données et donne ses instructions à LuaTeX pour créer le document PDF en utilisant uniquement l'interface Lua, et non le langage de macro habituel de TeX. Ensuite, LuaTeX produit le document PDF. Ainsi, Speedata utilise bien le _moteur_ TeX, mais pas le _langage_ TeX utilisé traditionnellement pour communiquer avec le moteur.

Speedata Publisher est particulièrement bien adapté à certains domaines dans lesquels les formats de TeX ont du mal. Par exemple, il permet de placer précisément les images dans les documents qui en comportent beaucoup, comme les catalogues de produits. Il permet aussi de définir des zones sur la page et d'indiquer quels flux de texte doivent aller dans quelles zones, ce qui est utile pour des magazines. En revanche, la séparation stricte entre les données et les instructions de mise en forme empêche [de corriger ponctuellement la mise en forme](/3_composition/texte/paragraphes/latex_fait_des_lignes_trop_longues). De plus, il faut programmer sa feuille de style soi-même à partir des éléments inclus dans le langage de Speedata : point d'extensions ici.

Pour en savoir plus :

- [Typesetting product catalogs and otherdatabase-driven documents with the Speedata Publisher](https://tug.org/TUGboat/tb41-2/tb128gundlach-speedata.pdf), Patrick Gundlach, TUGboat **41**:2 (2020).
- [Manuel de Speedata](https://doc.speedata.de/publisher/en/).
- [Exemples complets d'utilisation](https://github.com/speedata/examples).
- Explications sur la création de documents via Lua dans LuaTeX [sur le wiki de LuaTeX](https://wiki.luatex.org/index.php/TeX_without_TeX), avec des exemples détaillés.
