---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, paragraphes, mise en forme des paragraphes, 
              alinéa, renfoncement de la première ligne, début de paragraphe
---

# Comment changer le retrait en début de paragraphe ?

LaTeX ajoute une espace prédéfinie en début de paragraphe (ici en rouge) :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}           % Fonctions graphiques

\begin{document}
\noindent\tikz\path[fill=red] (0,0) rectangle (\parindent,1.5ex);%
Longtemps, je me suis couché de bonne heure. Parfois, 
à peine ma bougie éteinte, mes yeux se fermaient si vite que je 
n'avais pas le temps de me dire : \og{}Je m'endors.\fg{}
\end{document}
```

Avec <ctanpkg:babel> et l'option `french`, ce retrait mesure `1,5em` 
par défaut.

Les réponses données ci-après traitent n'importe quel paragraphe. 
La question "[](changer_l_indentation_du_premier_paragraphe)" évoque 
le cas particulier du premier paragraphe d'une section (associée 
à une règle typographique anglaise).


## Avec les commandes de base

Vous pouvez modifier la longueur de ce retrait en changeant la valeur
de la variable `\parindent` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}           % Fonctions graphiques

\begin{document}
\setlength{\parindent}{1.2cm}

\noindent\tikz\path[fill=red] (0,0) rectangle (\parindent,1.5ex);%
Longtemps, je me suis couché de bonne heure. Parfois, 
à peine ma bougie éteinte, mes yeux se fermaient si vite que je 
n'avais pas le temps de me dire : \og{}Je m'endors.\fg{}
\end{document}
```

On pourrait être aussi tenté d'utiliser `\hspace*{⟨longueur⟩}` en début 
de chaque paragraphe (avec `⟨longueur⟩` exprimée dans les 
[unités usuelles](/2_programmation/syntaxe/longueurs/unites_de_mesure_de_tex) 
de LaTeX). Cette solution est déconseillée, sauf s'il s'agit de modifier
un unique paragraphe. En effet, le document résultant deviendrait 
compliqué à maintenir, avec une mauvaise séparation du fond 
et de la forme.

Inversement, si vous souhaitez ponctuellement retirer ce retrait 
sans changer la mise en forme du reste de votre document, faites précéder
votre paragraphe de `\noindent` :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{tikz}           % Fonctions graphiques

\begin{document}
\noindent%
Longtemps, je me suis couché de bonne heure. Parfois, 
 peine ma bougie éteinte, mes yeux se fermaient si vite que je 
 n'avais pas le temps de me dire : \og{}Je m'endors.\fg{}
\end{document}
```