---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, index, entrée, référence
---

# Comment faire référence à une autre entrée dans l'index ?

Pour cela, il faut détourner la méthode permettant de changer le style 
des pages de référence telle que décrite à la question 
"[](/3_composition/annexes/index/changer_le_style_des_pages_de_reference)"
et utiliser la commande `\see` de l'extension <ctanpkg:makeidx>. 
Vous saisissez ainsi la commande d'index suivant pour le `⟨mot⟩` 
où vous souhaitez faire un renvoi vers une autre `⟨référence⟩` :

```{noedit}
\index{⟨mot⟩|see{⟨référence⟩}}
```

Dans ce cas, la commande `\see`, qui prend deux arguments, "avalera" le numéro
de page et affichera un renvoi vers le mot passé en premier argument. 
Par ailleurs, l'absence du caractère `\` devant `see` ci-dessus s'explique 
par le fait que c'est le programme générateur d'index qui va l'ajouter.

```
%!TEX makeindex document
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{makeidx}

  \makeindex

\begin{document}
\section{Sports}
Le sport, c'est fantastique ! Mes sports préférés 
sont :
\begin{itemize}
  \item l'escalade \index{Escalade} 
    et surtout les sorties en falaise ;
  \item les arts martiaux\index{Art martial} 
    comme le judo\index{Judo|see{Art martial}}.
\end{itemize}
\printindex
\end{document}
```


:::{sources}
- [Documentation] de <ctanpkg:makeidx>
:::