/**
 * Authors : quentin.vaney@gmail.com;xavier.frelechoz@gmail.com
 * Version : V1
 */

package LaTexScreenshooter;
import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ScreenShooter {

    // Method to load a web page in a specified browser
    private static void loadWebPage(String url) {
        try {
            Desktop.getDesktop().browse(new URL(url).toURI());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void closeWebPage(int delay) {
        try {
            Thread.sleep(delay);
            Robot robot = new Robot();
            robot.keyPress(KeyEvent.VK_CONTROL);
            robot.keyPress(KeyEvent.VK_W);
            robot.keyRelease(KeyEvent.VK_CONTROL);
            robot.keyRelease(KeyEvent.VK_W);
        } catch (InterruptedException | AWTException e) {
            e.printStackTrace();
        }
    }

    // Method to capture the browser window and save the screenshot
    public static void captureScreenshot(String url, int width, int height, String fileName, String path) {
        try {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            loadWebPage(url);

            // Wait for a certain time for the page to load (adjust as needed)
            try {
                Thread.sleep(4000); // Wait for 4 seconds
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
            Robot robot = new Robot();
            Rectangle area = new Rectangle(screenSize.width, screenSize.height);
            BufferedImage screenshot = robot.createScreenCapture(area);
            ImageIO.write(screenshot, "png", new File(path + fileName + ".png"));
            closeWebPage(2000);

            System.out.println("Screenshot saved at: " + path + fileName + ".png");
            System.out.println("Screenshot saved: " + fileName + ".png");
            //resizeImage(width, height, fileName);
        } catch (AWTException | IOException e) {
            e.printStackTrace();
        }
    }

    private static void resizeImage(int scaledWidth, int scaledHeight, String fileName) throws IOException {
        // Read the input image from the specified path
        File inputFile = new File(System.getProperty("user.dir") + "/" + fileName + ".png");
        BufferedImage inputImage = ImageIO.read(inputFile);

        // Create a BufferedImage with the new dimensions
        BufferedImage outputImage = new BufferedImage(scaledWidth, scaledHeight, inputImage.getType());

        // Resize the image
        Graphics2D graphics2D = outputImage.createGraphics();
        graphics2D.drawImage(inputImage, 0, 0, scaledWidth, scaledHeight, null);
        graphics2D.dispose();

        // Write the resized image to the specified path
        ImageIO.write(outputImage, "png", new File(fileName + ".png"));
    }
}
