/*
 * This procedure sets up the variables for the translation of plotter
 * coordinates to PostScript coordinates.
 *
 * Note: the procedure "defaults" may be incorporated here, however
 *	I have not had the time to work it out properly.
 *
 * Don McCormick
 */
#include "defn.h"

viewport()
{
    float pagewidth = 197.0;		/* Page width for Laser Printer */
    float pageheight = 280.0;		/* Page height for Laser Printer */
    float pwoffset = 12;
    float phoffset = 12;

    float psxmax, psymax;		/* Sizes scaled to the viewport */

    if (LANDSCAPE)		/* Default mode */
    {
	psymax = pagewidth * 0.938095;
	psxmax = psymax * (xmax - xmin)/ (ymax - ymin);
	xoffset += (pageheight + phoffset - psxmax) / 2.0;
	yoffset -= (pagewidth + pwoffset + psymax) / 2.0;
	printf("90 rotate\n");
    } else
    {
	psxmax = pagewidth * 0.938095;
	psymax = psxmax * (ymax - ymin) / (xmax - xmin);
	xoffset += (pagewidth + pwoffset - psxmax) / 2.0;
	yoffset += (pageheight + phoffset - psymax) / 2.0;
    }
    printf("%g mm %g mm translate\n", xoffset, yoffset);
    XSCALE = psxmax / xmax * SCALE;
    YSCALE = psymax / ymax * SCALE;
}
