/* dvgt.h - common header file for dvgtk
   $Id: dvgt.h,v 0.2 1997/03/28 03:16:09 tjchol01 Exp $
   Authors: Andrew Trevorrow, Ian Dall, Geoffrey Tobin, Tomasz J. Cholewo
 */

#ifndef __DVGT_H__
#define __DVGT_H__

#include "c-auto.h"

#include <ctype.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <kpathsea/debug.h>	/* debug */
#include <kpathsea/progname.h>	/* program_invocation_name */
#include <kpathsea/c-pathch.h>	/* DIR_SEP_STRING */
#include <kpathsea/types.h>	/* boolean */
#include <kpathsea/lib.h>	/* FATAL */

#define DVGT_VERSION "This is dvgtk 0.2."

/* Support for no prototypes */
#ifndef PARAMS
# if PROTOTYPES
#  define PARAMS(Args) Args
# else
#  define PARAMS(Args) ()
# endif
#endif

/* Word must be 32 bits.  Word is used in the PK bitmap operations. 
   For an architecture with 32-bit ints, Word can be int.
 */

typedef int Word;		/* SYSDEP:  ASSUMES exactly 32 bits in int. */
typedef void (*VFP) ();
typedef void *Anyptr;

/* Memory allocation */
void *Malloc PARAMS ((size_t));
#define Free(p, T)     (free((Anyptr) (p)), (p) = (T *) NULL)

/* Global declarations */
#define maxstring       1024
typedef char String[maxstring + 1];	/* Allow space for null terminator */

/* SYSDEP: cmd_help should have <= maxline chars/line */
#define maxline         80

/* The following variant records are needed because Pyramid Pascal
   does not provide type coercion.
   Note that we couldn't overlay INTEGER and BITSET because
   of the crazy storage scheme used to represent a set of 0..31
   where the bit order within a word is 7..0 15..8 23..16 31..24!
 */
typedef union byte_order
  {
    int int_;
    struct
      {
#ifdef WORDS_BIGENDIAN
	char _byte3, _byte2, _byte1, _byte0;
#else				/* not WORDS_BIGENDIAN */
	char _byte0, _byte1, _byte2, _byte3;
#endif				/* WORDS_BIGENDIAN */
      }
    _bytes;
  }
byte_order;

#define byte0(lvalue) ((byte_order *)(&lvalue))->_bytes._byte0
#define byte1(lvalue) ((byte_order *)(&lvalue))->_bytes._byte1
#define byte2(lvalue) ((byte_order *)(&lvalue))->_bytes._byte2
#define byte3(lvalue) ((byte_order *)(&lvalue))->_bytes._byte3

typedef struct int_or_bptr
  {
    boolean b;
    union
      {
	int int_;
	int *bptr;
      }
    UU;
  }
int_or_bptr;

typedef struct int_or_mptr
  {
    boolean b;
    union
      {
	int int_;
	Word *mptr;		/* bitmap */
      }
    UU;
  }
int_or_mptr;

#define bufflen         1024	/* size of buffer for holding DVI/PK bytes */
typedef unsigned char buffer[bufflen];

#endif /* __DVGT_H__ */
